# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AzureOrgVpcPeeringConnectionArgs', 'AzureOrgVpcPeeringConnection']

@pulumi.input_type
class AzureOrgVpcPeeringConnectionArgs:
    def __init__(__self__, *,
                 azure_subscription_id: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 organization_vpc_id: pulumi.Input[_builtins.str],
                 peer_azure_app_id: pulumi.Input[_builtins.str],
                 peer_azure_tenant_id: pulumi.Input[_builtins.str],
                 peer_resource_group: pulumi.Input[_builtins.str],
                 vnet_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AzureOrgVpcPeeringConnection resource.
        :param pulumi.Input[_builtins.str] azure_subscription_id: The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_azure_app_id: The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_azure_tenant_id: The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_resource_group: The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] vnet_name: The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "organization_vpc_id", organization_vpc_id)
        pulumi.set(__self__, "peer_azure_app_id", peer_azure_app_id)
        pulumi.set(__self__, "peer_azure_tenant_id", peer_azure_tenant_id)
        pulumi.set(__self__, "peer_resource_group", peer_resource_group)
        pulumi.set(__self__, "vnet_name", vnet_name)

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "azure_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @organization_vpc_id.setter
    def organization_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @peer_azure_app_id.setter
    def peer_azure_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_azure_app_id", value)

    @_builtins.property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @peer_azure_tenant_id.setter
    def peer_azure_tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_azure_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @peer_resource_group.setter
    def peer_resource_group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vnet_name", value)


@pulumi.input_type
class _AzureOrgVpcPeeringConnectionState:
    def __init__(__self__, *,
                 azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_azure_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzureOrgVpcPeeringConnection resources.
        :param pulumi.Input[_builtins.str] azure_subscription_id: The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_azure_app_id: The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_azure_tenant_id: The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_resource_group: The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peering_connection_id: The ID of the cloud provider for the peering connection.
        :param pulumi.Input[_builtins.str] state: State of the peering connection
        :param pulumi.Input[_builtins.str] vnet_name: The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        if azure_subscription_id is not None:
            pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if organization_vpc_id is not None:
            pulumi.set(__self__, "organization_vpc_id", organization_vpc_id)
        if peer_azure_app_id is not None:
            pulumi.set(__self__, "peer_azure_app_id", peer_azure_app_id)
        if peer_azure_tenant_id is not None:
            pulumi.set(__self__, "peer_azure_tenant_id", peer_azure_tenant_id)
        if peer_resource_group is not None:
            pulumi.set(__self__, "peer_resource_group", peer_resource_group)
        if peering_connection_id is not None:
            pulumi.set(__self__, "peering_connection_id", peering_connection_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azure_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @organization_vpc_id.setter
    def organization_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @peer_azure_app_id.setter
    def peer_azure_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_azure_app_id", value)

    @_builtins.property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @peer_azure_tenant_id.setter
    def peer_azure_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_azure_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @peer_resource_group.setter
    def peer_resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_resource_group", value)

    @_builtins.property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cloud provider for the peering connection.
        """
        return pulumi.get(self, "peering_connection_id")

    @peering_connection_id.setter
    def peering_connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_connection_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

    @vnet_name.setter
    def vnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vnet_name", value)


@pulumi.type_token("aiven:index/azureOrgVpcPeeringConnection:AzureOrgVpcPeeringConnection")
class AzureOrgVpcPeeringConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_azure_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an Azure VPC peering connection with an Aiven VPC.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_vpc = aiven.OrganizationVpc("example_vpc",
            organization_id=example["id"],
            cloud_name="azure-germany-westcentral",
            network_cidr="10.0.0.0/24")
        example_peering = aiven.AzureOrgVpcPeeringConnection("example_peering",
            organization_id=example_vpc.organization_id,
            organization_vpc_id=example_vpc.organization_vpc_id,
            azure_subscription_id="12345678-1234-1234-1234-123456789012",
            vnet_name="my-vnet",
            peer_resource_group="my-resource-group",
            peer_azure_app_id="87654321-4321-4321-4321-210987654321",
            peer_azure_tenant_id="11111111-2222-3333-4444-555555555555")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/azureOrgVpcPeeringConnection:AzureOrgVpcPeeringConnection example ORGANIZATION_ID/ORGANIZATION_VPC_ID/AZURE_SUBSCRIPTION_ID/VNET_NAME/RESOURCE_GROUP
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] azure_subscription_id: The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_azure_app_id: The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_azure_tenant_id: The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_resource_group: The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] vnet_name: The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureOrgVpcPeeringConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an Azure VPC peering connection with an Aiven VPC.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_vpc = aiven.OrganizationVpc("example_vpc",
            organization_id=example["id"],
            cloud_name="azure-germany-westcentral",
            network_cidr="10.0.0.0/24")
        example_peering = aiven.AzureOrgVpcPeeringConnection("example_peering",
            organization_id=example_vpc.organization_id,
            organization_vpc_id=example_vpc.organization_vpc_id,
            azure_subscription_id="12345678-1234-1234-1234-123456789012",
            vnet_name="my-vnet",
            peer_resource_group="my-resource-group",
            peer_azure_app_id="87654321-4321-4321-4321-210987654321",
            peer_azure_tenant_id="11111111-2222-3333-4444-555555555555")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/azureOrgVpcPeeringConnection:AzureOrgVpcPeeringConnection example ORGANIZATION_ID/ORGANIZATION_VPC_ID/AZURE_SUBSCRIPTION_ID/VNET_NAME/RESOURCE_GROUP
        ```

        :param str resource_name: The name of the resource.
        :param AzureOrgVpcPeeringConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureOrgVpcPeeringConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_azure_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureOrgVpcPeeringConnectionArgs.__new__(AzureOrgVpcPeeringConnectionArgs)

            if azure_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'azure_subscription_id'")
            __props__.__dict__["azure_subscription_id"] = azure_subscription_id
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            if organization_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_vpc_id'")
            __props__.__dict__["organization_vpc_id"] = organization_vpc_id
            if peer_azure_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_azure_app_id'")
            __props__.__dict__["peer_azure_app_id"] = peer_azure_app_id
            if peer_azure_tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_azure_tenant_id'")
            __props__.__dict__["peer_azure_tenant_id"] = peer_azure_tenant_id
            if peer_resource_group is None and not opts.urn:
                raise TypeError("Missing required property 'peer_resource_group'")
            __props__.__dict__["peer_resource_group"] = peer_resource_group
            if vnet_name is None and not opts.urn:
                raise TypeError("Missing required property 'vnet_name'")
            __props__.__dict__["vnet_name"] = vnet_name
            __props__.__dict__["peering_connection_id"] = None
            __props__.__dict__["state"] = None
        super(AzureOrgVpcPeeringConnection, __self__).__init__(
            'aiven:index/azureOrgVpcPeeringConnection:AzureOrgVpcPeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_azure_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_azure_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            peering_connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vnet_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'AzureOrgVpcPeeringConnection':
        """
        Get an existing AzureOrgVpcPeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] azure_subscription_id: The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] organization_id: Identifier of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: Identifier of the organization VPC.
        :param pulumi.Input[_builtins.str] peer_azure_app_id: The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_azure_tenant_id: The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peer_resource_group: The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] peering_connection_id: The ID of the cloud provider for the peering connection.
        :param pulumi.Input[_builtins.str] state: State of the peering connection
        :param pulumi.Input[_builtins.str] vnet_name: The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureOrgVpcPeeringConnectionState.__new__(_AzureOrgVpcPeeringConnectionState)

        __props__.__dict__["azure_subscription_id"] = azure_subscription_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["organization_vpc_id"] = organization_vpc_id
        __props__.__dict__["peer_azure_app_id"] = peer_azure_app_id
        __props__.__dict__["peer_azure_tenant_id"] = peer_azure_tenant_id
        __props__.__dict__["peer_resource_group"] = peer_resource_group
        __props__.__dict__["peering_connection_id"] = peering_connection_id
        __props__.__dict__["state"] = state
        __props__.__dict__["vnet_name"] = vnet_name
        return AzureOrgVpcPeeringConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure subscription in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "azure_subscription_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @_builtins.property
    @pulumi.getter(name="peerAzureAppId")
    def peer_azure_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure app that is allowed to create a peering to the Azure Virtual Network (VNet) in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_app_id")

    @_builtins.property
    @pulumi.getter(name="peerAzureTenantId")
    def peer_azure_tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure tenant ID in UUID4 format. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_azure_tenant_id")

    @_builtins.property
    @pulumi.getter(name="peerResourceGroup")
    def peer_resource_group(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure resource group associated with the VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "peer_resource_group")

    @_builtins.property
    @pulumi.getter(name="peeringConnectionId")
    def peering_connection_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cloud provider for the peering connection.
        """
        return pulumi.get(self, "peering_connection_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the peering connection
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure VNet. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "vnet_name")

