# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlinkJarApplicationArgs', 'FlinkJarApplication']

@pulumi.input_type
class FlinkJarApplicationArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlinkJarApplication resource.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] name: Application name. Maximum length: `128`.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application name. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FlinkJarApplicationState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 application_versions: Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationApplicationVersionArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 current_deployments: Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationCurrentDeploymentArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlinkJarApplication resources.
        :param pulumi.Input[_builtins.str] application_id: Application ID.
        :param pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationApplicationVersionArgs']]] application_versions: JarApplicationVersions.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] created_by: The creator of this entity.
        :param pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationCurrentDeploymentArgs']]] current_deployments: Flink JarApplicationDeployment.
        :param pulumi.Input[_builtins.str] name: Application name. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] updated_at: The update timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] updated_by: The latest updater of this entity.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_versions is not None:
            pulumi.set(__self__, "application_versions", application_versions)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if current_deployments is not None:
            pulumi.set(__self__, "current_deployments", current_deployments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationVersions")
    def application_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationApplicationVersionArgs']]]]:
        """
        JarApplicationVersions.
        """
        return pulumi.get(self, "application_versions")

    @application_versions.setter
    def application_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationApplicationVersionArgs']]]]):
        pulumi.set(self, "application_versions", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of this entity.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="currentDeployments")
    def current_deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationCurrentDeploymentArgs']]]]:
        """
        Flink JarApplicationDeployment.
        """
        return pulumi.get(self, "current_deployments")

    @current_deployments.setter
    def current_deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlinkJarApplicationCurrentDeploymentArgs']]]]):
        pulumi.set(self, "current_deployments", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application name. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest updater of this entity.
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)


@pulumi.type_token("aiven:index/flinkJarApplication:FlinkJarApplication")
class FlinkJarApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven for Apache Flink® jar application](https://aiven.io/docs/products/flink/howto/create-jar-application).

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example = aiven.Flink("example",
            project=example_aiven_project["project"],
            service_name="example-flink-service",
            cloud_name="google-europe-west1",
            plan="business-4",
            maintenance_window_dow="monday",
            maintenance_window_time="04:00:00",
            flink_user_config={
                "custom_code": True,
            })
        example_flink_jar_application = aiven.FlinkJarApplication("example",
            project=example.project,
            service_name=example.service_name,
            name="example-app-jar")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/flinkJarApplication:FlinkJarApplication example PROJECT/SERVICE_NAME/APPLICATION_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Application name. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkJarApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven for Apache Flink® jar application](https://aiven.io/docs/products/flink/howto/create-jar-application).

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example = aiven.Flink("example",
            project=example_aiven_project["project"],
            service_name="example-flink-service",
            cloud_name="google-europe-west1",
            plan="business-4",
            maintenance_window_dow="monday",
            maintenance_window_time="04:00:00",
            flink_user_config={
                "custom_code": True,
            })
        example_flink_jar_application = aiven.FlinkJarApplication("example",
            project=example.project,
            service_name=example.service_name,
            name="example-app-jar")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/flinkJarApplication:FlinkJarApplication example PROJECT/SERVICE_NAME/APPLICATION_ID
        ```

        :param str resource_name: The name of the resource.
        :param FlinkJarApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkJarApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkJarApplicationArgs.__new__(FlinkJarApplicationArgs)

            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["application_id"] = None
            __props__.__dict__["application_versions"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["current_deployments"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        super(FlinkJarApplication, __self__).__init__(
            'aiven:index/flinkJarApplication:FlinkJarApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            application_versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlinkJarApplicationApplicationVersionArgs', 'FlinkJarApplicationApplicationVersionArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            current_deployments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlinkJarApplicationCurrentDeploymentArgs', 'FlinkJarApplicationCurrentDeploymentArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlinkJarApplication':
        """
        Get an existing FlinkJarApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Application ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlinkJarApplicationApplicationVersionArgs', 'FlinkJarApplicationApplicationVersionArgsDict']]]] application_versions: JarApplicationVersions.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] created_by: The creator of this entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlinkJarApplicationCurrentDeploymentArgs', 'FlinkJarApplicationCurrentDeploymentArgsDict']]]] current_deployments: Flink JarApplicationDeployment.
        :param pulumi.Input[_builtins.str] name: Application name. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] updated_at: The update timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] updated_by: The latest updater of this entity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkJarApplicationState.__new__(_FlinkJarApplicationState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["application_versions"] = application_versions
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["current_deployments"] = current_deployments
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        return FlinkJarApplication(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        Application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="applicationVersions")
    def application_versions(self) -> pulumi.Output[Sequence['outputs.FlinkJarApplicationApplicationVersion']]:
        """
        JarApplicationVersions.
        """
        return pulumi.get(self, "application_versions")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The creator of this entity.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="currentDeployments")
    def current_deployments(self) -> pulumi.Output[Sequence['outputs.FlinkJarApplicationCurrentDeployment']]:
        """
        Flink JarApplicationDeployment.
        """
        return pulumi.get(self, "current_deployments")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Application name. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        The latest updater of this entity.
        """
        return pulumi.get(self, "updated_by")

