# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKafkaSchemaConfigurationResult',
    'AwaitableGetKafkaSchemaConfigurationResult',
    'get_kafka_schema_configuration',
    'get_kafka_schema_configuration_output',
]

@pulumi.output_type
class GetKafkaSchemaConfigurationResult:
    """
    A collection of values returned by getKafkaSchemaConfiguration.
    """
    def __init__(__self__, compatibility_level=None, id=None, project=None, schema=None, schema_type=None, service_name=None, subject_name=None, version=None):
        if compatibility_level and not isinstance(compatibility_level, str):
            raise TypeError("Expected argument 'compatibility_level' to be a str")
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if schema_type and not isinstance(schema_type, str):
            raise TypeError("Expected argument 'schema_type' to be a str")
        pulumi.set(__self__, "schema_type", schema_type)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> _builtins.str:
        """
        Kafka Schemas compatibility level. The possible values are `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`, `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE` and `NONE`.
        """
        return pulumi.get(self, "compatibility_level")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        Kafka Schema configuration. Should be a valid Avro, JSON, or Protobuf schema, depending on the schema type.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> _builtins.str:
        """
        Kafka Schema configuration type. Defaults to AVRO. The possible values are `AVRO`, `JSON` and `PROTOBUF`.
        """
        return pulumi.get(self, "schema_type")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> _builtins.str:
        """
        The Kafka Schema Subject name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "subject_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        Kafka Schema configuration version.
        """
        return pulumi.get(self, "version")


class AwaitableGetKafkaSchemaConfigurationResult(GetKafkaSchemaConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaSchemaConfigurationResult(
            compatibility_level=self.compatibility_level,
            id=self.id,
            project=self.project,
            schema=self.schema,
            schema_type=self.schema_type,
            service_name=self.service_name,
            subject_name=self.subject_name,
            version=self.version)


def get_kafka_schema_configuration(project: Optional[_builtins.str] = None,
                                   service_name: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaSchemaConfigurationResult:
    """
    The Kafka Schema Configuration data source provides information about the existing Aiven Kafka Schema Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    config = aiven.KafkaSchemaConfiguration("config",
        project=kafka_schemas_project1["project"],
        service_name=kafka_service1["serviceName"],
        compatibility_level="BACKWARD")
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getKafkaSchemaConfiguration:getKafkaSchemaConfiguration', __args__, opts=opts, typ=GetKafkaSchemaConfigurationResult).value

    return AwaitableGetKafkaSchemaConfigurationResult(
        compatibility_level=pulumi.get(__ret__, 'compatibility_level'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        schema=pulumi.get(__ret__, 'schema'),
        schema_type=pulumi.get(__ret__, 'schema_type'),
        service_name=pulumi.get(__ret__, 'service_name'),
        subject_name=pulumi.get(__ret__, 'subject_name'),
        version=pulumi.get(__ret__, 'version'))
def get_kafka_schema_configuration_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                                          service_name: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKafkaSchemaConfigurationResult]:
    """
    The Kafka Schema Configuration data source provides information about the existing Aiven Kafka Schema Configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    config = aiven.KafkaSchemaConfiguration("config",
        project=kafka_schemas_project1["project"],
        service_name=kafka_service1["serviceName"],
        compatibility_level="BACKWARD")
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getKafkaSchemaConfiguration:getKafkaSchemaConfiguration', __args__, opts=opts, typ=GetKafkaSchemaConfigurationResult)
    return __ret__.apply(lambda __response__: GetKafkaSchemaConfigurationResult(
        compatibility_level=pulumi.get(__response__, 'compatibility_level'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        schema=pulumi.get(__response__, 'schema'),
        schema_type=pulumi.get(__response__, 'schema_type'),
        service_name=pulumi.get(__response__, 'service_name'),
        subject_name=pulumi.get(__response__, 'subject_name'),
        version=pulumi.get(__response__, 'version')))
