# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOrganizationAddressResult',
    'AwaitableGetOrganizationAddressResult',
    'get_organization_address',
    'get_organization_address_output',
]

@pulumi.output_type
class GetOrganizationAddressResult:
    """
    A collection of values returned by getOrganizationAddress.
    """
    def __init__(__self__, address_id=None, address_lines=None, city=None, country_code=None, create_time=None, id=None, name=None, organization_id=None, state=None, timeouts=None, update_time=None, zip_code=None):
        if address_id and not isinstance(address_id, str):
            raise TypeError("Expected argument 'address_id' to be a str")
        pulumi.set(__self__, "address_id", address_id)
        if address_lines and not isinstance(address_lines, list):
            raise TypeError("Expected argument 'address_lines' to be a list")
        pulumi.set(__self__, "address_lines", address_lines)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if timeouts and not isinstance(timeouts, dict):
            raise TypeError("Expected argument 'timeouts' to be a dict")
        pulumi.set(__self__, "timeouts", timeouts)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if zip_code and not isinstance(zip_code, str):
            raise TypeError("Expected argument 'zip_code' to be a str")
        pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="addressId")
    def address_id(self) -> _builtins.str:
        """
        Address ID.
        """
        return pulumi.get(self, "address_id")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Sequence[_builtins.str]:
        """
        Address Lines.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        City.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> _builtins.str:
        """
        Country Code.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Create Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Resource ID, a composite of `organization_id` and `address_id` IDs.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of a company.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        ID of an organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional['outputs.GetOrganizationAddressTimeoutsResult']:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        Update Time.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> _builtins.str:
        """
        Zip Code.
        """
        return pulumi.get(self, "zip_code")


class AwaitableGetOrganizationAddressResult(GetOrganizationAddressResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationAddressResult(
            address_id=self.address_id,
            address_lines=self.address_lines,
            city=self.city,
            country_code=self.country_code,
            create_time=self.create_time,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            state=self.state,
            timeouts=self.timeouts,
            update_time=self.update_time,
            zip_code=self.zip_code)


def get_organization_address(address_id: Optional[_builtins.str] = None,
                             organization_id: Optional[_builtins.str] = None,
                             timeouts: Optional[Union['GetOrganizationAddressTimeoutsArgs', 'GetOrganizationAddressTimeoutsArgsDict']] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationAddressResult:
    """
    Gets information about an organization address.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str address_id: Address ID.
    :param _builtins.str organization_id: ID of an organization.
    """
    __args__ = dict()
    __args__['addressId'] = address_id
    __args__['organizationId'] = organization_id
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getOrganizationAddress:getOrganizationAddress', __args__, opts=opts, typ=GetOrganizationAddressResult).value

    return AwaitableGetOrganizationAddressResult(
        address_id=pulumi.get(__ret__, 'address_id'),
        address_lines=pulumi.get(__ret__, 'address_lines'),
        city=pulumi.get(__ret__, 'city'),
        country_code=pulumi.get(__ret__, 'country_code'),
        create_time=pulumi.get(__ret__, 'create_time'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        state=pulumi.get(__ret__, 'state'),
        timeouts=pulumi.get(__ret__, 'timeouts'),
        update_time=pulumi.get(__ret__, 'update_time'),
        zip_code=pulumi.get(__ret__, 'zip_code'))
def get_organization_address_output(address_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    timeouts: Optional[pulumi.Input[Optional[Union['GetOrganizationAddressTimeoutsArgs', 'GetOrganizationAddressTimeoutsArgsDict']]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOrganizationAddressResult]:
    """
    Gets information about an organization address.

    **This resource is in the beta stage and may change without notice.** Set
    the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.


    :param _builtins.str address_id: Address ID.
    :param _builtins.str organization_id: ID of an organization.
    """
    __args__ = dict()
    __args__['addressId'] = address_id
    __args__['organizationId'] = organization_id
    __args__['timeouts'] = timeouts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getOrganizationAddress:getOrganizationAddress', __args__, opts=opts, typ=GetOrganizationAddressResult)
    return __ret__.apply(lambda __response__: GetOrganizationAddressResult(
        address_id=pulumi.get(__response__, 'address_id'),
        address_lines=pulumi.get(__response__, 'address_lines'),
        city=pulumi.get(__response__, 'city'),
        country_code=pulumi.get(__response__, 'country_code'),
        create_time=pulumi.get(__response__, 'create_time'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        state=pulumi.get(__response__, 'state'),
        timeouts=pulumi.get(__response__, 'timeouts'),
        update_time=pulumi.get(__response__, 'update_time'),
        zip_code=pulumi.get(__response__, 'zip_code')))
