# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetValkeyUserResult',
    'AwaitableGetValkeyUserResult',
    'get_valkey_user',
    'get_valkey_user_output',
]

@pulumi.output_type
class GetValkeyUserResult:
    """
    A collection of values returned by getValkeyUser.
    """
    def __init__(__self__, id=None, password=None, project=None, service_name=None, type=None, username=None, valkey_acl_categories=None, valkey_acl_channels=None, valkey_acl_commands=None, valkey_acl_keys=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if valkey_acl_categories and not isinstance(valkey_acl_categories, list):
            raise TypeError("Expected argument 'valkey_acl_categories' to be a list")
        pulumi.set(__self__, "valkey_acl_categories", valkey_acl_categories)
        if valkey_acl_channels and not isinstance(valkey_acl_channels, list):
            raise TypeError("Expected argument 'valkey_acl_channels' to be a list")
        pulumi.set(__self__, "valkey_acl_channels", valkey_acl_channels)
        if valkey_acl_commands and not isinstance(valkey_acl_commands, list):
            raise TypeError("Expected argument 'valkey_acl_commands' to be a list")
        pulumi.set(__self__, "valkey_acl_commands", valkey_acl_commands)
        if valkey_acl_keys and not isinstance(valkey_acl_keys, list):
            raise TypeError("Expected argument 'valkey_acl_keys' to be a list")
        pulumi.set(__self__, "valkey_acl_keys", valkey_acl_keys)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The Valkey service user's password.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        User account type, such as primary or regular account.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="valkeyAclCategories")
    def valkey_acl_categories(self) -> Sequence[_builtins.str]:
        """
        Allow or disallow command categories. To allow a category use the prefix `+@` and to disallow use `-@`. See the [Valkey documentation](https://valkey.io/topics/acl/) for details on the ACL feature. The field is required with`valkey_acl_commands` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_categories")

    @_builtins.property
    @pulumi.getter(name="valkeyAclChannels")
    def valkey_acl_channels(self) -> Sequence[_builtins.str]:
        """
        Allows and disallows access to pub/sub channels. Entries are defined as standard glob patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_channels")

    @_builtins.property
    @pulumi.getter(name="valkeyAclCommands")
    def valkey_acl_commands(self) -> Sequence[_builtins.str]:
        """
        Defines rules for individual commands. To allow a command use the prefix `+` and to disallow use `-`. The field is required with`valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_commands")

    @_builtins.property
    @pulumi.getter(name="valkeyAclKeys")
    def valkey_acl_keys(self) -> Sequence[_builtins.str]:
        """
        Key access rules. Entries are defined as standard glob patterns. The field is required with`valkey_acl_categories` and `valkey_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "valkey_acl_keys")


class AwaitableGetValkeyUserResult(GetValkeyUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetValkeyUserResult(
            id=self.id,
            password=self.password,
            project=self.project,
            service_name=self.service_name,
            type=self.type,
            username=self.username,
            valkey_acl_categories=self.valkey_acl_categories,
            valkey_acl_channels=self.valkey_acl_channels,
            valkey_acl_commands=self.valkey_acl_commands,
            valkey_acl_keys=self.valkey_acl_keys)


def get_valkey_user(project: Optional[_builtins.str] = None,
                    service_name: Optional[_builtins.str] = None,
                    username: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetValkeyUserResult:
    """
    The Valkey User data source provides information about the existing Aiven for Valkey user.


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getValkeyUser:getValkeyUser', __args__, opts=opts, typ=GetValkeyUserResult).value

    return AwaitableGetValkeyUserResult(
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'),
        type=pulumi.get(__ret__, 'type'),
        username=pulumi.get(__ret__, 'username'),
        valkey_acl_categories=pulumi.get(__ret__, 'valkey_acl_categories'),
        valkey_acl_channels=pulumi.get(__ret__, 'valkey_acl_channels'),
        valkey_acl_commands=pulumi.get(__ret__, 'valkey_acl_commands'),
        valkey_acl_keys=pulumi.get(__ret__, 'valkey_acl_keys'))
def get_valkey_user_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                           service_name: Optional[pulumi.Input[_builtins.str]] = None,
                           username: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetValkeyUserResult]:
    """
    The Valkey User data source provides information about the existing Aiven for Valkey user.


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str username: Name of the Valkey service user. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getValkeyUser:getValkeyUser', __args__, opts=opts, typ=GetValkeyUserResult)
    return __ret__.apply(lambda __response__: GetValkeyUserResult(
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name'),
        type=pulumi.get(__response__, 'type'),
        username=pulumi.get(__response__, 'username'),
        valkey_acl_categories=pulumi.get(__response__, 'valkey_acl_categories'),
        valkey_acl_channels=pulumi.get(__response__, 'valkey_acl_channels'),
        valkey_acl_commands=pulumi.get(__response__, 'valkey_acl_commands'),
        valkey_acl_keys=pulumi.get(__response__, 'valkey_acl_keys')))
