# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['KafkaQuotaArgs', 'KafkaQuota']

@pulumi.input_type
class KafkaQuotaArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KafkaQuota resource.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] client_id: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        :param pulumi.Input[_builtins.int] consumer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.int] producer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.float] request_percentage: Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
               Exceeding this limit triggers throttling.
               The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        :param pulumi.Input[_builtins.str] user: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if consumer_byte_rate is not None:
            pulumi.set(__self__, "consumer_byte_rate", consumer_byte_rate)
        if producer_byte_rate is not None:
            pulumi.set(__self__, "producer_byte_rate", producer_byte_rate)
        if request_percentage is not None:
            pulumi.set(__self__, "request_percentage", request_percentage)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents a logical group of clients, assigned a unique name by the client application.
        Quotas can be applied based on user, client-id, or both.
        The most relevant quota is chosen for each connection.
        All connections within a quota group share the same quota.
        It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="consumerByteRate")
    def consumer_byte_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
        Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
        Exceeding this limit results in client throttling.
        """
        return pulumi.get(self, "consumer_byte_rate")

    @consumer_byte_rate.setter
    def consumer_byte_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "consumer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="producerByteRate")
    def producer_byte_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
        Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
        Exceeding this limit results in client throttling.
        """
        return pulumi.get(self, "producer_byte_rate")

    @producer_byte_rate.setter
    def producer_byte_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "producer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="requestPercentage")
    def request_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
        Exceeding this limit triggers throttling.
        The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        """
        return pulumi.get(self, "request_percentage")

    @request_percentage.setter
    def request_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "request_percentage", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents a logical group of clients, assigned a unique name by the client application.
        Quotas can be applied based on user, client-id, or both.
        The most relevant quota is chosen for each connection.
        All connections within a quota group share the same quota.
        It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class _KafkaQuotaState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KafkaQuota resources.
        :param pulumi.Input[_builtins.str] client_id: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        :param pulumi.Input[_builtins.int] consumer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.int] producer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.float] request_percentage: Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
               Exceeding this limit triggers throttling.
               The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if consumer_byte_rate is not None:
            pulumi.set(__self__, "consumer_byte_rate", consumer_byte_rate)
        if producer_byte_rate is not None:
            pulumi.set(__self__, "producer_byte_rate", producer_byte_rate)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_percentage is not None:
            pulumi.set(__self__, "request_percentage", request_percentage)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents a logical group of clients, assigned a unique name by the client application.
        Quotas can be applied based on user, client-id, or both.
        The most relevant quota is chosen for each connection.
        All connections within a quota group share the same quota.
        It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="consumerByteRate")
    def consumer_byte_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
        Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
        Exceeding this limit results in client throttling.
        """
        return pulumi.get(self, "consumer_byte_rate")

    @consumer_byte_rate.setter
    def consumer_byte_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "consumer_byte_rate", value)

    @_builtins.property
    @pulumi.getter(name="producerByteRate")
    def producer_byte_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
        Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
        Exceeding this limit results in client throttling.
        """
        return pulumi.get(self, "producer_byte_rate")

    @producer_byte_rate.setter
    def producer_byte_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "producer_byte_rate", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="requestPercentage")
    def request_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
        Exceeding this limit triggers throttling.
        The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        """
        return pulumi.get(self, "request_percentage")

    @request_percentage.setter
    def request_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "request_percentage", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Represents a logical group of clients, assigned a unique name by the client application.
        Quotas can be applied based on user, client-id, or both.
        The most relevant quota is chosen for each connection.
        All connections within a quota group share the same quota.
        It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("aiven:index/kafkaQuota:KafkaQuota")
class KafkaQuota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages quotas for an Aiven for Apache Kafka® service user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_quota = aiven.KafkaQuota("example_quota",
            project=foo["project"],
            service_name=example_kafka["serviceName"],
            user="example-kafka-user",
            client_id="example_client",
            consumer_byte_rate=1000,
            producer_byte_rate=1000,
            request_percentage=50)
        ```

        ## Import

        When both USER and CLIENT_ID are specified

        ```sh
        $ pulumi import aiven:index/kafkaQuota:KafkaQuota example_quota PROJECT/SERVICE_NAME/CLIENT_ID/USER
        ```

        When only USER is specified

        ```sh
        $ pulumi import aiven:index/kafkaQuota:KafkaQuota example_quota PROJECT/SERVICE_NAME//USER
        ```

        When only CLIENT_ID is specified

        ```sh
        $ pulumi import aiven:index/kafkaQuota:KafkaQuota example_quota PROJECT/SERVICE_NAME/CLIENT_ID/
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        :param pulumi.Input[_builtins.int] consumer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.int] producer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.float] request_percentage: Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
               Exceeding this limit triggers throttling.
               The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaQuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages quotas for an Aiven for Apache Kafka® service user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_quota = aiven.KafkaQuota("example_quota",
            project=foo["project"],
            service_name=example_kafka["serviceName"],
            user="example-kafka-user",
            client_id="example_client",
            consumer_byte_rate=1000,
            producer_byte_rate=1000,
            request_percentage=50)
        ```

        ## Import

        When both USER and CLIENT_ID are specified

        ```sh
        $ pulumi import aiven:index/kafkaQuota:KafkaQuota example_quota PROJECT/SERVICE_NAME/CLIENT_ID/USER
        ```

        When only USER is specified

        ```sh
        $ pulumi import aiven:index/kafkaQuota:KafkaQuota example_quota PROJECT/SERVICE_NAME//USER
        ```

        When only CLIENT_ID is specified

        ```sh
        $ pulumi import aiven:index/kafkaQuota:KafkaQuota example_quota PROJECT/SERVICE_NAME/CLIENT_ID/
        ```

        :param str resource_name: The name of the resource.
        :param KafkaQuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaQuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 request_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaQuotaArgs.__new__(KafkaQuotaArgs)

            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["consumer_byte_rate"] = consumer_byte_rate
            __props__.__dict__["producer_byte_rate"] = producer_byte_rate
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["request_percentage"] = request_percentage
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["user"] = user
        super(KafkaQuota, __self__).__init__(
            'aiven:index/kafkaQuota:KafkaQuota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            consumer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
            producer_byte_rate: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            request_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'KafkaQuota':
        """
        Get an existing KafkaQuota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        :param pulumi.Input[_builtins.int] consumer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.int] producer_byte_rate: Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
               Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
               Exceeding this limit results in client throttling.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.float] request_percentage: Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
               Exceeding this limit triggers throttling.
               The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] user: Represents a logical group of clients, assigned a unique name by the client application.
               Quotas can be applied based on user, client-id, or both.
               The most relevant quota is chosen for each connection.
               All connections within a quota group share the same quota.
               It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaQuotaState.__new__(_KafkaQuotaState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["consumer_byte_rate"] = consumer_byte_rate
        __props__.__dict__["producer_byte_rate"] = producer_byte_rate
        __props__.__dict__["project"] = project
        __props__.__dict__["request_percentage"] = request_percentage
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["user"] = user
        return KafkaQuota(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Represents a logical group of clients, assigned a unique name by the client application.
        Quotas can be applied based on user, client-id, or both.
        The most relevant quota is chosen for each connection.
        All connections within a quota group share the same quota.
        It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="consumerByteRate")
    def consumer_byte_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
        Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
        Exceeding this limit results in client throttling.
        """
        return pulumi.get(self, "consumer_byte_rate")

    @_builtins.property
    @pulumi.getter(name="producerByteRate")
    def producer_byte_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Defines the bandwidth limit in bytes/sec for each group of clients sharing a quota.
        Every distinct client group is allocated a specific quota, as defined by the cluster, on a per-broker basis.
        Exceeding this limit results in client throttling.
        """
        return pulumi.get(self, "producer_byte_rate")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="requestPercentage")
    def request_percentage(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Sets the maximum percentage of CPU time that a client group can use on request handler I/O and network threads per broker within a quota window.
        Exceeding this limit triggers throttling.
        The quota, expressed as a percentage, also indicates the total allowable CPU usage for the client groups sharing the quota.
        """
        return pulumi.get(self, "request_percentage")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Represents a logical group of clients, assigned a unique name by the client application.
        Quotas can be applied based on user, client-id, or both.
        The most relevant quota is chosen for each connection.
        All connections within a quota group share the same quota.
        It is possible to set default quotas for each (user, client-id), user or client-id group by specifying 'default'
        """
        return pulumi.get(self, "user")

