# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MirrorMakerReplicationFlowArgs', 'MirrorMakerReplicationFlow']

@pulumi.input_type
class MirrorMakerReplicationFlowArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[_builtins.bool],
                 offset_syncs_topic_location: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 replication_policy_class: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 source_cluster: pulumi.Input[_builtins.str],
                 target_cluster: pulumi.Input[_builtins.str],
                 config_properties_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 emit_backward_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 emit_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exactly_once_delivery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a MirrorMakerReplicationFlow resource.
        :param pulumi.Input[_builtins.bool] enable: Enables replication flow for a service.
        :param pulumi.Input[_builtins.str] offset_syncs_topic_location: Offset syncs topic location. The possible values are `source` and `target`.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[_builtins.str] service_name: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source_cluster: Source cluster alias. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] target_cluster: Target cluster alias. Maximum length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] config_properties_excludes: List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        :param pulumi.Input[_builtins.bool] emit_backward_heartbeats_enabled: Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] emit_heartbeats_enabled: Enables emitting heartbeats to the target cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] exactly_once_delivery_enabled: Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        :param pulumi.Input[_builtins.int] replication_factor: Replication factor, `>= 1`.
        :param pulumi.Input[_builtins.bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[_builtins.int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics: The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics_blacklists: The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "offset_syncs_topic_location", offset_syncs_topic_location)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "replication_policy_class", replication_policy_class)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "source_cluster", source_cluster)
        pulumi.set(__self__, "target_cluster", target_cluster)
        if config_properties_excludes is not None:
            pulumi.set(__self__, "config_properties_excludes", config_properties_excludes)
        if emit_backward_heartbeats_enabled is not None:
            pulumi.set(__self__, "emit_backward_heartbeats_enabled", emit_backward_heartbeats_enabled)
        if emit_heartbeats_enabled is not None:
            pulumi.set(__self__, "emit_heartbeats_enabled", emit_heartbeats_enabled)
        if exactly_once_delivery_enabled is not None:
            pulumi.set(__self__, "exactly_once_delivery_enabled", exactly_once_delivery_enabled)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if sync_group_offsets_enabled is not None:
            pulumi.set(__self__, "sync_group_offsets_enabled", sync_group_offsets_enabled)
        if sync_group_offsets_interval_seconds is not None:
            pulumi.set(__self__, "sync_group_offsets_interval_seconds", sync_group_offsets_interval_seconds)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if topics_blacklists is not None:
            pulumi.set(__self__, "topics_blacklists", topics_blacklists)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Input[_builtins.bool]:
        """
        Enables replication flow for a service.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="offsetSyncsTopicLocation")
    def offset_syncs_topic_location(self) -> pulumi.Input[_builtins.str]:
        """
        Offset syncs topic location. The possible values are `source` and `target`.
        """
        return pulumi.get(self, "offset_syncs_topic_location")

    @offset_syncs_topic_location.setter
    def offset_syncs_topic_location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "offset_syncs_topic_location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> pulumi.Input[_builtins.str]:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @replication_policy_class.setter
    def replication_policy_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "replication_policy_class", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> pulumi.Input[_builtins.str]:
        """
        Source cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @source_cluster.setter
    def source_cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_cluster", value)

    @_builtins.property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> pulumi.Input[_builtins.str]:
        """
        Target cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @target_cluster.setter
    def target_cluster(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_cluster", value)

    @_builtins.property
    @pulumi.getter(name="configPropertiesExcludes")
    def config_properties_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        """
        return pulumi.get(self, "config_properties_excludes")

    @config_properties_excludes.setter
    def config_properties_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_properties_excludes", value)

    @_builtins.property
    @pulumi.getter(name="emitBackwardHeartbeatsEnabled")
    def emit_backward_heartbeats_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_backward_heartbeats_enabled")

    @emit_backward_heartbeats_enabled.setter
    def emit_backward_heartbeats_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "emit_backward_heartbeats_enabled", value)

    @_builtins.property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables emitting heartbeats to the target cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @emit_heartbeats_enabled.setter
    def emit_heartbeats_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "emit_heartbeats_enabled", value)

    @_builtins.property
    @pulumi.getter(name="exactlyOnceDeliveryEnabled")
    def exactly_once_delivery_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        """
        return pulumi.get(self, "exactly_once_delivery_enabled")

    @exactly_once_delivery_enabled.setter
    def exactly_once_delivery_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exactly_once_delivery_enabled", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Replication factor, `>= 1`.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @sync_group_offsets_enabled.setter
    def sync_group_offsets_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_group_offsets_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @sync_group_offsets_interval_seconds.setter
    def sync_group_offsets_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sync_group_offsets_interval_seconds", value)

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "topics", value)

    @_builtins.property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics_blacklists")

    @topics_blacklists.setter
    def topics_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "topics_blacklists", value)


@pulumi.input_type
class _MirrorMakerReplicationFlowState:
    def __init__(__self__, *,
                 config_properties_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 emit_backward_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 emit_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 exactly_once_delivery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 offset_syncs_topic_location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_policy_class: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 target_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering MirrorMakerReplicationFlow resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] config_properties_excludes: List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        :param pulumi.Input[_builtins.bool] emit_backward_heartbeats_enabled: Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] emit_heartbeats_enabled: Enables emitting heartbeats to the target cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] enable: Enables replication flow for a service.
        :param pulumi.Input[_builtins.bool] exactly_once_delivery_enabled: Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        :param pulumi.Input[_builtins.str] offset_syncs_topic_location: Offset syncs topic location. The possible values are `source` and `target`.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.int] replication_factor: Replication factor, `>= 1`.
        :param pulumi.Input[_builtins.str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[_builtins.str] service_name: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source_cluster: Source cluster alias. Maximum length: `128`.
        :param pulumi.Input[_builtins.bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[_builtins.int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[_builtins.str] target_cluster: Target cluster alias. Maximum length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics: The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics_blacklists: The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        if config_properties_excludes is not None:
            pulumi.set(__self__, "config_properties_excludes", config_properties_excludes)
        if emit_backward_heartbeats_enabled is not None:
            pulumi.set(__self__, "emit_backward_heartbeats_enabled", emit_backward_heartbeats_enabled)
        if emit_heartbeats_enabled is not None:
            pulumi.set(__self__, "emit_heartbeats_enabled", emit_heartbeats_enabled)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if exactly_once_delivery_enabled is not None:
            pulumi.set(__self__, "exactly_once_delivery_enabled", exactly_once_delivery_enabled)
        if offset_syncs_topic_location is not None:
            pulumi.set(__self__, "offset_syncs_topic_location", offset_syncs_topic_location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_policy_class is not None:
            pulumi.set(__self__, "replication_policy_class", replication_policy_class)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if source_cluster is not None:
            pulumi.set(__self__, "source_cluster", source_cluster)
        if sync_group_offsets_enabled is not None:
            pulumi.set(__self__, "sync_group_offsets_enabled", sync_group_offsets_enabled)
        if sync_group_offsets_interval_seconds is not None:
            pulumi.set(__self__, "sync_group_offsets_interval_seconds", sync_group_offsets_interval_seconds)
        if target_cluster is not None:
            pulumi.set(__self__, "target_cluster", target_cluster)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if topics_blacklists is not None:
            pulumi.set(__self__, "topics_blacklists", topics_blacklists)

    @_builtins.property
    @pulumi.getter(name="configPropertiesExcludes")
    def config_properties_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        """
        return pulumi.get(self, "config_properties_excludes")

    @config_properties_excludes.setter
    def config_properties_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "config_properties_excludes", value)

    @_builtins.property
    @pulumi.getter(name="emitBackwardHeartbeatsEnabled")
    def emit_backward_heartbeats_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_backward_heartbeats_enabled")

    @emit_backward_heartbeats_enabled.setter
    def emit_backward_heartbeats_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "emit_backward_heartbeats_enabled", value)

    @_builtins.property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables emitting heartbeats to the target cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @emit_heartbeats_enabled.setter
    def emit_heartbeats_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "emit_heartbeats_enabled", value)

    @_builtins.property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables replication flow for a service.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable", value)

    @_builtins.property
    @pulumi.getter(name="exactlyOnceDeliveryEnabled")
    def exactly_once_delivery_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        """
        return pulumi.get(self, "exactly_once_delivery_enabled")

    @exactly_once_delivery_enabled.setter
    def exactly_once_delivery_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exactly_once_delivery_enabled", value)

    @_builtins.property
    @pulumi.getter(name="offsetSyncsTopicLocation")
    def offset_syncs_topic_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Offset syncs topic location. The possible values are `source` and `target`.
        """
        return pulumi.get(self, "offset_syncs_topic_location")

    @offset_syncs_topic_location.setter
    def offset_syncs_topic_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offset_syncs_topic_location", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Replication factor, `>= 1`.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @_builtins.property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @replication_policy_class.setter
    def replication_policy_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_policy_class", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @source_cluster.setter
    def source_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_cluster", value)

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @sync_group_offsets_enabled.setter
    def sync_group_offsets_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_group_offsets_enabled", value)

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @sync_group_offsets_interval_seconds.setter
    def sync_group_offsets_interval_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sync_group_offsets_interval_seconds", value)

    @_builtins.property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @target_cluster.setter
    def target_cluster(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_cluster", value)

    @_builtins.property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "topics", value)

    @_builtins.property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics_blacklists")

    @topics_blacklists.setter
    def topics_blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "topics_blacklists", value)


@pulumi.type_token("aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow")
class MirrorMakerReplicationFlow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_properties_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 emit_backward_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 emit_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 exactly_once_delivery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 offset_syncs_topic_location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_policy_class: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 target_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven for Apache Kafka® MirrorMaker 2](https://aiven.io/docs/products/kafka/kafka-mirrormaker) replication flow.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_replication_flow = aiven.MirrorMakerReplicationFlow("example_replication_flow",
            project=example_project["project"],
            service_name=example_kafka["serviceName"],
            source_cluster=source["serviceName"],
            target_cluster=target["serviceName"],
            enable=True,
            topics=[".*"],
            topics_blacklists=[
                ".*[\\\\-\\\\.]internal",
                ".*\\\\.replica",
                "__.*",
            ],
            config_properties_excludes=[
                "follower\\\\.replication\\\\.throttled\\\\.replicas",
                "leader\\\\.replication\\\\.throttled\\\\.replicas",
                "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",
                "message\\\\.timestamp\\\\.type",
                "unclean\\\\.leader\\\\.election\\\\.enable",
                "min\\\\.insync\\\\.replicas",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow example_replication_flow PROJECT/SERVICE_NAME/SOURCE_CLUSTER/TARGET_CLUSTER
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] config_properties_excludes: List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        :param pulumi.Input[_builtins.bool] emit_backward_heartbeats_enabled: Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] emit_heartbeats_enabled: Enables emitting heartbeats to the target cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] enable: Enables replication flow for a service.
        :param pulumi.Input[_builtins.bool] exactly_once_delivery_enabled: Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        :param pulumi.Input[_builtins.str] offset_syncs_topic_location: Offset syncs topic location. The possible values are `source` and `target`.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.int] replication_factor: Replication factor, `>= 1`.
        :param pulumi.Input[_builtins.str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[_builtins.str] service_name: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source_cluster: Source cluster alias. Maximum length: `128`.
        :param pulumi.Input[_builtins.bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[_builtins.int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[_builtins.str] target_cluster: Target cluster alias. Maximum length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics: The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics_blacklists: The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MirrorMakerReplicationFlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven for Apache Kafka® MirrorMaker 2](https://aiven.io/docs/products/kafka/kafka-mirrormaker) replication flow.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_replication_flow = aiven.MirrorMakerReplicationFlow("example_replication_flow",
            project=example_project["project"],
            service_name=example_kafka["serviceName"],
            source_cluster=source["serviceName"],
            target_cluster=target["serviceName"],
            enable=True,
            topics=[".*"],
            topics_blacklists=[
                ".*[\\\\-\\\\.]internal",
                ".*\\\\.replica",
                "__.*",
            ],
            config_properties_excludes=[
                "follower\\\\.replication\\\\.throttled\\\\.replicas",
                "leader\\\\.replication\\\\.throttled\\\\.replicas",
                "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",
                "message\\\\.timestamp\\\\.type",
                "unclean\\\\.leader\\\\.election\\\\.enable",
                "min\\\\.insync\\\\.replicas",
            ])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow example_replication_flow PROJECT/SERVICE_NAME/SOURCE_CLUSTER/TARGET_CLUSTER
        ```

        :param str resource_name: The name of the resource.
        :param MirrorMakerReplicationFlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MirrorMakerReplicationFlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_properties_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 emit_backward_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 emit_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 exactly_once_delivery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 offset_syncs_topic_location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_policy_class: Optional[pulumi.Input[_builtins.str]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_group_offsets_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_group_offsets_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 target_cluster: Optional[pulumi.Input[_builtins.str]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MirrorMakerReplicationFlowArgs.__new__(MirrorMakerReplicationFlowArgs)

            __props__.__dict__["config_properties_excludes"] = config_properties_excludes
            __props__.__dict__["emit_backward_heartbeats_enabled"] = emit_backward_heartbeats_enabled
            __props__.__dict__["emit_heartbeats_enabled"] = emit_heartbeats_enabled
            if enable is None and not opts.urn:
                raise TypeError("Missing required property 'enable'")
            __props__.__dict__["enable"] = enable
            __props__.__dict__["exactly_once_delivery_enabled"] = exactly_once_delivery_enabled
            if offset_syncs_topic_location is None and not opts.urn:
                raise TypeError("Missing required property 'offset_syncs_topic_location'")
            __props__.__dict__["offset_syncs_topic_location"] = offset_syncs_topic_location
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["replication_factor"] = replication_factor
            if replication_policy_class is None and not opts.urn:
                raise TypeError("Missing required property 'replication_policy_class'")
            __props__.__dict__["replication_policy_class"] = replication_policy_class
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if source_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'source_cluster'")
            __props__.__dict__["source_cluster"] = source_cluster
            __props__.__dict__["sync_group_offsets_enabled"] = sync_group_offsets_enabled
            __props__.__dict__["sync_group_offsets_interval_seconds"] = sync_group_offsets_interval_seconds
            if target_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'target_cluster'")
            __props__.__dict__["target_cluster"] = target_cluster
            __props__.__dict__["topics"] = topics
            __props__.__dict__["topics_blacklists"] = topics_blacklists
        super(MirrorMakerReplicationFlow, __self__).__init__(
            'aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_properties_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            emit_backward_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            emit_heartbeats_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            enable: Optional[pulumi.Input[_builtins.bool]] = None,
            exactly_once_delivery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            offset_syncs_topic_location: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            replication_factor: Optional[pulumi.Input[_builtins.int]] = None,
            replication_policy_class: Optional[pulumi.Input[_builtins.str]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_cluster: Optional[pulumi.Input[_builtins.str]] = None,
            sync_group_offsets_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            sync_group_offsets_interval_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            target_cluster: Optional[pulumi.Input[_builtins.str]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            topics_blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'MirrorMakerReplicationFlow':
        """
        Get an existing MirrorMakerReplicationFlow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] config_properties_excludes: List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        :param pulumi.Input[_builtins.bool] emit_backward_heartbeats_enabled: Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] emit_heartbeats_enabled: Enables emitting heartbeats to the target cluster. The default value is `false`.
        :param pulumi.Input[_builtins.bool] enable: Enables replication flow for a service.
        :param pulumi.Input[_builtins.bool] exactly_once_delivery_enabled: Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        :param pulumi.Input[_builtins.str] offset_syncs_topic_location: Offset syncs topic location. The possible values are `source` and `target`.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.int] replication_factor: Replication factor, `>= 1`.
        :param pulumi.Input[_builtins.str] replication_policy_class: Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        :param pulumi.Input[_builtins.str] service_name: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] source_cluster: Source cluster alias. Maximum length: `128`.
        :param pulumi.Input[_builtins.bool] sync_group_offsets_enabled: Sync consumer group offsets. The default value is `false`.
        :param pulumi.Input[_builtins.int] sync_group_offsets_interval_seconds: Frequency of consumer group offset sync. The default value is `1`.
        :param pulumi.Input[_builtins.str] target_cluster: Target cluster alias. Maximum length: `128`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics: The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] topics_blacklists: The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MirrorMakerReplicationFlowState.__new__(_MirrorMakerReplicationFlowState)

        __props__.__dict__["config_properties_excludes"] = config_properties_excludes
        __props__.__dict__["emit_backward_heartbeats_enabled"] = emit_backward_heartbeats_enabled
        __props__.__dict__["emit_heartbeats_enabled"] = emit_heartbeats_enabled
        __props__.__dict__["enable"] = enable
        __props__.__dict__["exactly_once_delivery_enabled"] = exactly_once_delivery_enabled
        __props__.__dict__["offset_syncs_topic_location"] = offset_syncs_topic_location
        __props__.__dict__["project"] = project
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["replication_policy_class"] = replication_policy_class
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["source_cluster"] = source_cluster
        __props__.__dict__["sync_group_offsets_enabled"] = sync_group_offsets_enabled
        __props__.__dict__["sync_group_offsets_interval_seconds"] = sync_group_offsets_interval_seconds
        __props__.__dict__["target_cluster"] = target_cluster
        __props__.__dict__["topics"] = topics
        __props__.__dict__["topics_blacklists"] = topics_blacklists
        return MirrorMakerReplicationFlow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configPropertiesExcludes")
    def config_properties_excludes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of topic configuration properties and regular expressions to not replicate. The properties that are not replicated by default are: `follower.replication.throttled.replicas`, `leader.replication.throttled.replicas`, `message.timestamp.difference.max.ms`, `message.timestamp.type`, `unclean.leader.election.enable`, and `min.insync.replicas`. Setting this overrides the defaults. For example, to enable replication for 'min.insync.replicas' and 'unclean.leader.election.enable' set this to: ["follower\\\\.replication\\\\.throttled\\\\.replicas", "leader\\\\.replication\\\\.throttled\\\\.replicas", "message\\\\.timestamp\\\\.difference\\\\.max\\\\.ms",  "message\\\\.timestamp\\\\.type"]
        """
        return pulumi.get(self, "config_properties_excludes")

    @_builtins.property
    @pulumi.getter(name="emitBackwardHeartbeatsEnabled")
    def emit_backward_heartbeats_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables emitting heartbeats to the direction opposite to the flow, i.e. to the source cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_backward_heartbeats_enabled")

    @_builtins.property
    @pulumi.getter(name="emitHeartbeatsEnabled")
    def emit_heartbeats_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables emitting heartbeats to the target cluster. The default value is `false`.
        """
        return pulumi.get(self, "emit_heartbeats_enabled")

    @_builtins.property
    @pulumi.getter
    def enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables replication flow for a service.
        """
        return pulumi.get(self, "enable")

    @_builtins.property
    @pulumi.getter(name="exactlyOnceDeliveryEnabled")
    def exactly_once_delivery_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables exactly-once message delivery. Set this to `enabled` for new replications. The default value is `false`.
        """
        return pulumi.get(self, "exactly_once_delivery_enabled")

    @_builtins.property
    @pulumi.getter(name="offsetSyncsTopicLocation")
    def offset_syncs_topic_location(self) -> pulumi.Output[_builtins.str]:
        """
        Offset syncs topic location. The possible values are `source` and `target`.
        """
        return pulumi.get(self, "offset_syncs_topic_location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Replication factor, `>= 1`.
        """
        return pulumi.get(self, "replication_factor")

    @_builtins.property
    @pulumi.getter(name="replicationPolicyClass")
    def replication_policy_class(self) -> pulumi.Output[_builtins.str]:
        """
        Replication policy class. The possible values are `org.apache.kafka.connect.mirror.DefaultReplicationPolicy` and `org.apache.kafka.connect.mirror.IdentityReplicationPolicy`. The default value is `org.apache.kafka.connect.mirror.DefaultReplicationPolicy`.
        """
        return pulumi.get(self, "replication_policy_class")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="sourceCluster")
    def source_cluster(self) -> pulumi.Output[_builtins.str]:
        """
        Source cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "source_cluster")

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsEnabled")
    def sync_group_offsets_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Sync consumer group offsets. The default value is `false`.
        """
        return pulumi.get(self, "sync_group_offsets_enabled")

    @_builtins.property
    @pulumi.getter(name="syncGroupOffsetsIntervalSeconds")
    def sync_group_offsets_interval_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Frequency of consumer group offset sync. The default value is `1`.
        """
        return pulumi.get(self, "sync_group_offsets_interval_seconds")

    @_builtins.property
    @pulumi.getter(name="targetCluster")
    def target_cluster(self) -> pulumi.Output[_builtins.str]:
        """
        Target cluster alias. Maximum length: `128`.
        """
        return pulumi.get(self, "target_cluster")

    @_builtins.property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The topics to include in the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics")

    @_builtins.property
    @pulumi.getter(name="topicsBlacklists")
    def topics_blacklists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The topics to exclude from the replica defined by a [list of regular expressions in Java format](https://aiven.io/docs/products/kafka/kafka-mirrormaker/concepts/replication-flow-topics-regex).
        """
        return pulumi.get(self, "topics_blacklists")

