# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 add_account_owners_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_project: Optional[pulumi.Input[_builtins.str]] = None,
                 default_cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_source_project_billing_group: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] project: The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        :param pulumi.Input[_builtins.str] account_id: Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.bool] add_account_owners_admin_access: If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        :param pulumi.Input[_builtins.str] billing_group: The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] copy_from_project: The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] default_cloud: Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        :param pulumi.Input[_builtins.bool] use_source_project_billing_group: Use the same billing group that is used in source project.
        """
        pulumi.set(__self__, "project", project)
        if account_id is not None:
            warnings.warn("""Use parent_id instead. This field will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: Use parent_id instead. This field will be removed in the next major release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if add_account_owners_admin_access is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""", DeprecationWarning)
            pulumi.log.warn("""add_account_owners_admin_access is deprecated: This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""")
        if add_account_owners_admin_access is not None:
            pulumi.set(__self__, "add_account_owners_admin_access", add_account_owners_admin_access)
        if billing_group is not None:
            pulumi.set(__self__, "billing_group", billing_group)
        if copy_from_project is not None:
            pulumi.set(__self__, "copy_from_project", copy_from_project)
        if default_cloud is not None:
            pulumi.set(__self__, "default_cloud", default_cloud)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if technical_emails is not None:
            pulumi.set(__self__, "technical_emails", technical_emails)
        if use_source_project_billing_group is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""use_source_project_billing_group is deprecated: This field is deprecated and will be removed in the next major release.""")
        if use_source_project_billing_group is not None:
            pulumi.set(__self__, "use_source_project_billing_group", use_source_project_billing_group)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""Use parent_id instead. This field will be removed in the next major release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="addAccountOwnersAdminAccess")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""")
    def add_account_owners_admin_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        """
        return pulumi.get(self, "add_account_owners_admin_access")

    @add_account_owners_admin_access.setter
    def add_account_owners_admin_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "add_account_owners_admin_access", value)

    @_builtins.property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group")

    @billing_group.setter
    def billing_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_group", value)

    @_builtins.property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "copy_from_project")

    @copy_from_project.setter
    def copy_from_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "copy_from_project", value)

    @_builtins.property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        """
        return pulumi.get(self, "default_cloud")

    @default_cloud.setter
    def default_cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_cloud", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]]]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @technical_emails.setter
    def technical_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "technical_emails", value)

    @_builtins.property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release.""")
    def use_source_project_billing_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use the same billing group that is used in source project.
        """
        return pulumi.get(self, "use_source_project_billing_group")

    @use_source_project_billing_group.setter
    def use_source_project_billing_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_source_project_billing_group", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 add_account_owners_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 available_credits: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_project: Optional[pulumi.Input[_builtins.str]] = None,
                 default_cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_balance: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_method: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_source_project_billing_group: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] account_id: Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.bool] add_account_owners_admin_access: If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        :param pulumi.Input[_builtins.str] available_credits: The number of trial or promotional credits remaining for this project.
        :param pulumi.Input[_builtins.str] billing_group: The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] ca_cert: The CA certificate for the project. This is required for configuring clients that connect to certain services like Kafka.
        :param pulumi.Input[_builtins.str] copy_from_project: The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] default_cloud: Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        :param pulumi.Input[_builtins.str] estimated_balance: The monthly running estimate for this project for the current billing period.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] payment_method: The payment type used for this project. For example,`card`.
        :param pulumi.Input[_builtins.str] project: The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        :param pulumi.Input[_builtins.bool] use_source_project_billing_group: Use the same billing group that is used in source project.
        """
        if account_id is not None:
            warnings.warn("""Use parent_id instead. This field will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""account_id is deprecated: Use parent_id instead. This field will be removed in the next major release.""")
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if add_account_owners_admin_access is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""", DeprecationWarning)
            pulumi.log.warn("""add_account_owners_admin_access is deprecated: This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""")
        if add_account_owners_admin_access is not None:
            pulumi.set(__self__, "add_account_owners_admin_access", add_account_owners_admin_access)
        if available_credits is not None:
            pulumi.set(__self__, "available_credits", available_credits)
        if billing_group is not None:
            pulumi.set(__self__, "billing_group", billing_group)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if copy_from_project is not None:
            pulumi.set(__self__, "copy_from_project", copy_from_project)
        if default_cloud is not None:
            pulumi.set(__self__, "default_cloud", default_cloud)
        if estimated_balance is not None:
            pulumi.set(__self__, "estimated_balance", estimated_balance)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if payment_method is not None:
            pulumi.set(__self__, "payment_method", payment_method)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if technical_emails is not None:
            pulumi.set(__self__, "technical_emails", technical_emails)
        if use_source_project_billing_group is not None:
            warnings.warn("""This field is deprecated and will be removed in the next major release.""", DeprecationWarning)
            pulumi.log.warn("""use_source_project_billing_group is deprecated: This field is deprecated and will be removed in the next major release.""")
        if use_source_project_billing_group is not None:
            pulumi.set(__self__, "use_source_project_billing_group", use_source_project_billing_group)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""Use parent_id instead. This field will be removed in the next major release.""")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="addAccountOwnersAdminAccess")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""")
    def add_account_owners_admin_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        """
        return pulumi.get(self, "add_account_owners_admin_access")

    @add_account_owners_admin_access.setter
    def add_account_owners_admin_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "add_account_owners_admin_access", value)

    @_builtins.property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of trial or promotional credits remaining for this project.
        """
        return pulumi.get(self, "available_credits")

    @available_credits.setter
    def available_credits(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "available_credits", value)

    @_builtins.property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group")

    @billing_group.setter
    def billing_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_group", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CA certificate for the project. This is required for configuring clients that connect to certain services like Kafka.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "copy_from_project")

    @copy_from_project.setter
    def copy_from_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "copy_from_project", value)

    @_builtins.property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        """
        return pulumi.get(self, "default_cloud")

    @default_cloud.setter
    def default_cloud(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_cloud", value)

    @_builtins.property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly running estimate for this project for the current billing period.
        """
        return pulumi.get(self, "estimated_balance")

    @estimated_balance.setter
    def estimated_balance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "estimated_balance", value)

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_id", value)

    @_builtins.property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The payment type used for this project. For example,`card`.
        """
        return pulumi.get(self, "payment_method")

    @payment_method.setter
    def payment_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_method", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]]]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @technical_emails.setter
    def technical_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "technical_emails", value)

    @_builtins.property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release.""")
    def use_source_project_billing_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use the same billing group that is used in source project.
        """
        return pulumi.get(self, "use_source_project_billing_group")

    @use_source_project_billing_group.setter
    def use_source_project_billing_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_source_project_billing_group", value)


@pulumi.type_token("aiven:index/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 add_account_owners_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_project: Optional[pulumi.Input[_builtins.str]] = None,
                 default_cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTagArgs', 'ProjectTagArgsDict']]]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_source_project_billing_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven project](https://aiven.io/docs/platform/concepts/orgs-units-projects#projects).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_project = aiven.Project("example_project",
            project="example-project",
            parent_id=main["id"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/project:Project example_project PROJECT
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.bool] add_account_owners_admin_access: If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        :param pulumi.Input[_builtins.str] billing_group: The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] copy_from_project: The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] default_cloud: Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] project: The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectTagArgs', 'ProjectTagArgsDict']]]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        :param pulumi.Input[_builtins.bool] use_source_project_billing_group: Use the same billing group that is used in source project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven project](https://aiven.io/docs/platform/concepts/orgs-units-projects#projects).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_project = aiven.Project("example_project",
            project="example-project",
            parent_id=main["id"])
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/project:Project example_project PROJECT
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 add_account_owners_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_group: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_from_project: Optional[pulumi.Input[_builtins.str]] = None,
                 default_cloud: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTagArgs', 'ProjectTagArgsDict']]]]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 use_source_project_billing_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["add_account_owners_admin_access"] = add_account_owners_admin_access
            __props__.__dict__["billing_group"] = billing_group
            __props__.__dict__["copy_from_project"] = copy_from_project
            __props__.__dict__["default_cloud"] = default_cloud
            __props__.__dict__["parent_id"] = parent_id
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["tags"] = tags
            __props__.__dict__["technical_emails"] = technical_emails
            __props__.__dict__["use_source_project_billing_group"] = use_source_project_billing_group
            __props__.__dict__["available_credits"] = None
            __props__.__dict__["ca_cert"] = None
            __props__.__dict__["estimated_balance"] = None
            __props__.__dict__["payment_method"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCert"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Project, __self__).__init__(
            'aiven:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            add_account_owners_admin_access: Optional[pulumi.Input[_builtins.bool]] = None,
            available_credits: Optional[pulumi.Input[_builtins.str]] = None,
            billing_group: Optional[pulumi.Input[_builtins.str]] = None,
            ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            copy_from_project: Optional[pulumi.Input[_builtins.str]] = None,
            default_cloud: Optional[pulumi.Input[_builtins.str]] = None,
            estimated_balance: Optional[pulumi.Input[_builtins.str]] = None,
            parent_id: Optional[pulumi.Input[_builtins.str]] = None,
            payment_method: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectTagArgs', 'ProjectTagArgsDict']]]]] = None,
            technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            use_source_project_billing_group: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.bool] add_account_owners_admin_access: If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        :param pulumi.Input[_builtins.str] available_credits: The number of trial or promotional credits remaining for this project.
        :param pulumi.Input[_builtins.str] billing_group: The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] ca_cert: The CA certificate for the project. This is required for configuring clients that connect to certain services like Kafka.
        :param pulumi.Input[_builtins.str] copy_from_project: The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] default_cloud: Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        :param pulumi.Input[_builtins.str] estimated_balance: The monthly running estimate for this project for the current billing period.
        :param pulumi.Input[_builtins.str] parent_id: Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        :param pulumi.Input[_builtins.str] payment_method: The payment type used for this project. For example,`card`.
        :param pulumi.Input[_builtins.str] project: The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectTagArgs', 'ProjectTagArgsDict']]]] tags: Tags are key-value pairs that allow you to categorize projects.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] technical_emails: The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        :param pulumi.Input[_builtins.bool] use_source_project_billing_group: Use the same billing group that is used in source project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["add_account_owners_admin_access"] = add_account_owners_admin_access
        __props__.__dict__["available_credits"] = available_credits
        __props__.__dict__["billing_group"] = billing_group
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["copy_from_project"] = copy_from_project
        __props__.__dict__["default_cloud"] = default_cloud
        __props__.__dict__["estimated_balance"] = estimated_balance
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["payment_method"] = payment_method
        __props__.__dict__["project"] = project
        __props__.__dict__["tags"] = tags
        __props__.__dict__["technical_emails"] = technical_emails
        __props__.__dict__["use_source_project_billing_group"] = use_source_project_billing_group
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    @_utilities.deprecated("""Use parent_id instead. This field will be removed in the next major release.""")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Link a project to an existing account using its account ID. This field is deprecated. Use `parent_id` instead. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="addAccountOwnersAdminAccess")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release. Currently, it will always be set to true, regardless of the value set in the manifest.""")
    def add_account_owners_admin_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If parent_id is set, grant account owner team admin access to the new project. The default value is `true`.
        """
        return pulumi.get(self, "add_account_owners_admin_access")

    @_builtins.property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> pulumi.Output[_builtins.str]:
        """
        The number of trial or promotional credits remaining for this project.
        """
        return pulumi.get(self, "available_credits")

    @_builtins.property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the billing group this project is assigned to. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[_builtins.str]:
        """
        The CA certificate for the project. This is required for configuring clients that connect to certain services like Kafka.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the project to copy billing information, technical contacts, and some other project attributes from. This is most useful to set up the same billing method when you use bank transfers to pay invoices for other projects. You can only do this when creating a project. You can't set the billing over the API for an existing. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "copy_from_project")

    @_builtins.property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default cloud provider and region where services are hosted. This can be changed after the project is created and will not affect existing services.
        """
        return pulumi.get(self, "default_cloud")

    @_builtins.property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> pulumi.Output[_builtins.str]:
        """
        The monthly running estimate for this project for the current billing period.
        """
        return pulumi.get(self, "estimated_balance")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Link a project to an [organization or organizational unit](https://aiven.io/docs/platform/concepts/orgs-units-projects) by using its ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> pulumi.Output[_builtins.str]:
        """
        The payment type used for this project. For example,`card`.
        """
        return pulumi.get(self, "payment_method")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project. Names must be globally unique among all Aiven customers and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectTag']]]:
        """
        Tags are key-value pairs that allow you to categorize projects.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The email addresses for [project contacts](https://aiven.io/docs/platform/howto/technical-emails), who will receive important alerts and updates about this project and its services. You can also set email contacts at the service level. It's good practice to keep these up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @_builtins.property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    @_utilities.deprecated("""This field is deprecated and will be removed in the next major release.""")
    def use_source_project_billing_group(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use the same billing group that is used in source project.
        """
        return pulumi.get(self, "use_source_project_billing_group")

