# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RedisUserArgs', 'RedisUser']

@pulumi.input_type
class RedisUserArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RedisUser resource.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] username: The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] password: The password of the Redis User.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_categories: Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_channels: Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_commands: Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_keys: Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if redis_acl_categories is not None:
            pulumi.set(__self__, "redis_acl_categories", redis_acl_categories)
        if redis_acl_channels is not None:
            pulumi.set(__self__, "redis_acl_channels", redis_acl_channels)
        if redis_acl_commands is not None:
            pulumi.set(__self__, "redis_acl_commands", redis_acl_commands)
        if redis_acl_keys is not None:
            pulumi.set(__self__, "redis_acl_keys", redis_acl_keys)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the Redis User.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="redisAclCategories")
    def redis_acl_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_categories")

    @redis_acl_categories.setter
    def redis_acl_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_categories", value)

    @_builtins.property
    @pulumi.getter(name="redisAclChannels")
    def redis_acl_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_channels")

    @redis_acl_channels.setter
    def redis_acl_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_channels", value)

    @_builtins.property
    @pulumi.getter(name="redisAclCommands")
    def redis_acl_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_commands")

    @redis_acl_commands.setter
    def redis_acl_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_commands", value)

    @_builtins.property
    @pulumi.getter(name="redisAclKeys")
    def redis_acl_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_keys")

    @redis_acl_keys.setter
    def redis_acl_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_keys", value)


@pulumi.input_type
class _RedisUserState:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RedisUser resources.
        :param pulumi.Input[_builtins.str] password: The password of the Redis User.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_categories: Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_channels: Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_commands: Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_keys: Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] type: Type of the user account. Tells whether the user is the primary account or a regular account.
        :param pulumi.Input[_builtins.str] username: The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if redis_acl_categories is not None:
            pulumi.set(__self__, "redis_acl_categories", redis_acl_categories)
        if redis_acl_channels is not None:
            pulumi.set(__self__, "redis_acl_channels", redis_acl_channels)
        if redis_acl_commands is not None:
            pulumi.set(__self__, "redis_acl_commands", redis_acl_commands)
        if redis_acl_keys is not None:
            pulumi.set(__self__, "redis_acl_keys", redis_acl_keys)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the Redis User.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="redisAclCategories")
    def redis_acl_categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_categories")

    @redis_acl_categories.setter
    def redis_acl_categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_categories", value)

    @_builtins.property
    @pulumi.getter(name="redisAclChannels")
    def redis_acl_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_channels")

    @redis_acl_channels.setter
    def redis_acl_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_channels", value)

    @_builtins.property
    @pulumi.getter(name="redisAclCommands")
    def redis_acl_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_commands")

    @redis_acl_commands.setter
    def redis_acl_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_commands", value)

    @_builtins.property
    @pulumi.getter(name="redisAclKeys")
    def redis_acl_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_keys")

    @redis_acl_keys.setter
    def redis_acl_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_acl_keys", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the user account. Tells whether the user is the primary account or a regular account.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("aiven:index/redisUser:RedisUser")
class RedisUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an [Aiven for Caching](https://aiven.io/docs/products/caching) (formerly known as Aiven for Redis®) service user.

        !> **End of life notice**
        In March 2024, a new licensing model was announced for Redis® that impacts the Aiven for Caching offering (formerly Aiven for Redis®).
        Aiven for Caching is entering its end-of-life cycle to comply with Redis's copyright and license agreements.
        From **February 15th, 2025**, it will not be possible to start a new Aiven for Caching service, but existing services up until version 7.2 will still be available until end of life.
        From **March 31st, 2025**, Aiven for Caching will no longer be available and all existing services will be migrated to Aiven for Valkey™.
        You can [upgrade to Valkey for free](https://aiven.io/docs/products/caching/howto/upgrade-aiven-for-caching-to-valkey) before then
        and update your existing `Redis` resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.RedisUser("foo",
            service_name=bar["serviceName"],
            project="my-project",
            username="user-1",
            password="Test$1234")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/redisUser:RedisUser foo PROJECT/SERVICE_NAME/USERNAME
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The password of the Redis User.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_categories: Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_channels: Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_commands: Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_keys: Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] username: The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an [Aiven for Caching](https://aiven.io/docs/products/caching) (formerly known as Aiven for Redis®) service user.

        !> **End of life notice**
        In March 2024, a new licensing model was announced for Redis® that impacts the Aiven for Caching offering (formerly Aiven for Redis®).
        Aiven for Caching is entering its end-of-life cycle to comply with Redis's copyright and license agreements.
        From **February 15th, 2025**, it will not be possible to start a new Aiven for Caching service, but existing services up until version 7.2 will still be available until end of life.
        From **March 31st, 2025**, Aiven for Caching will no longer be available and all existing services will be migrated to Aiven for Valkey™.
        You can [upgrade to Valkey for free](https://aiven.io/docs/products/caching/howto/upgrade-aiven-for-caching-to-valkey) before then
        and update your existing `Redis` resources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        foo = aiven.RedisUser("foo",
            service_name=bar["serviceName"],
            project="my-project",
            username="user-1",
            password="Test$1234")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/redisUser:RedisUser foo PROJECT/SERVICE_NAME/USERNAME
        ```

        :param str resource_name: The name of the resource.
        :param RedisUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 redis_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisUserArgs.__new__(RedisUserArgs)

            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["redis_acl_categories"] = redis_acl_categories
            __props__.__dict__["redis_acl_channels"] = redis_acl_channels
            __props__.__dict__["redis_acl_commands"] = redis_acl_commands
            __props__.__dict__["redis_acl_keys"] = redis_acl_keys
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RedisUser, __self__).__init__(
            'aiven:index/redisUser:RedisUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            redis_acl_categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            redis_acl_channels: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            redis_acl_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            redis_acl_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'RedisUser':
        """
        Get an existing RedisUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] password: The password of the Redis User.
        :param pulumi.Input[_builtins.str] project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_categories: Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_channels: Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_commands: Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] redis_acl_keys: Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] type: Type of the user account. Tells whether the user is the primary account or a regular account.
        :param pulumi.Input[_builtins.str] username: The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisUserState.__new__(_RedisUserState)

        __props__.__dict__["password"] = password
        __props__.__dict__["project"] = project
        __props__.__dict__["redis_acl_categories"] = redis_acl_categories
        __props__.__dict__["redis_acl_channels"] = redis_acl_channels
        __props__.__dict__["redis_acl_commands"] = redis_acl_commands
        __props__.__dict__["redis_acl_keys"] = redis_acl_keys
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["type"] = type
        __props__.__dict__["username"] = username
        return RedisUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the Redis User.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="redisAclCategories")
    def redis_acl_categories(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines command category rules. The field is required with`redis_acl_commands` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_categories")

    @_builtins.property
    @pulumi.getter(name="redisAclChannels")
    def redis_acl_channels(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines the permitted pub/sub channel patterns. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_channels")

    @_builtins.property
    @pulumi.getter(name="redisAclCommands")
    def redis_acl_commands(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines rules for individual commands. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_commands")

    @_builtins.property
    @pulumi.getter(name="redisAclKeys")
    def redis_acl_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Defines key access rules. The field is required with`redis_acl_categories` and `redis_acl_keys`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "redis_acl_keys")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the user account. Tells whether the user is the primary account or a regular account.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The actual name of the Redis User. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "username")

