def add(a: int, b: int) -> int: ...

class ArrayD1:
    def __init__(self, size: int) -> None: ...
    def get(self, n: int) -> float: ...
    def set(self, n: int, d: float) -> None: ...
    def __getitem__(self, index: int) -> float: ...
    def __setitem__(self, index: int, value: float) -> None: ...
    def __len__(self) -> int: ...

class ArrayD2:
    def __init__(self, rows: int, cols: int) -> None: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key: tuple[int, int]) -> float: ...
    def __setitem__(self, key: tuple[int, int], value: float) -> None: ...

class ArrayI1:
    def __init__(self, size: int) -> None: ...
    def get(self, n: int) -> int: ...
    def set(self, n: int, d: int) -> None: ...
    def __getitem__(self, index: int) -> int: ...
    def __setitem__(self, index: int, value: int) -> None: ...
    def __len__(self) -> int: ...


class ArrayI2:
    def __init__(self, rows: int, cols: int) -> None: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key: tuple[int, int]) -> int: ...
    def __setitem__(self, key: tuple[int, int], value: int) -> None: ...

class Layer:
    def __init__(self, prev_layer_size: int, this_size: int) -> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, dval: ArrayD2) -> ArrayD2: ...

class ReLU:
    def __init__(self) -> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, dval: ArrayD2) -> ArrayD2: ...

class Softmax:
    def __init__(self) -> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, dval: ArrayD2) -> ArrayD2: ...

class CCE:
    def __init__(self) -> None: ...
    def forward(self, output: ArrayD2, actual: ArrayI2) -> float: ...
    def backward(self, output: ArrayD2, actual: ArrayI2) -> ArrayD2: ...

class SGD:
    def __init__(self) -> None: ...
    def optimize(self, layer: Layer) -> None: ...

class Model:
    def __init__(self) -> None: ...
    def forwardGA(self, x: ArrayD1) -> ArrayD1: ...
    def randomize(self, strength: float) -> None: ...
    def save_model(self, path: str) -> None: ...
    def load_model(self, path: str) -> None: ...
    def add_softmax(self) -> None: ...
    def add_relu(self) -> None: ...
    def add_layer(self, prev_size: int, cur_size: int) -> None: ...

class TestActivation:
    def __init__(self)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class ReLU64:
    def __init__(self, alpha: float)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class Linear64:
    def __init__(self, m: float, b: float, flow: bool)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class Sigmoid64:
    def __init__(self)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class LeakyReLU64:
    def __init__(self, minimum: float, alpha: float)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class Step64:
    def __init__(self, minimum: float, maximum: float, flip: float)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class Softmax64:
    def __init__(self)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class ReverseReLU64:
    def __init__(self, maximum: float)-> None: ...
    def forward(self, x: ArrayD2) -> ArrayD2: ...
    def backward(self, x: ArrayD2) -> ArrayD2: ...

class CCE64:
    def __init__(self, maximum: float)-> None: ...
    def forward(self, x: ArrayD2, y_true: ArrayI1) -> float: ...
    def backward(self, x: ArrayD2, y_true: ArrayI1) -> ArrayD2: ...

class ndarray:
    def __init__(self, shape: tuple, zeros: bool, dtype: str, scalar: float | int)-> None: ...
    
def breed_models(model1: Model, model2: Model, prop: float) -> Model: ...
def copy_model(model: Model) -> Model: ...