# JSONB Generation Method Benchmark Results

**Date:** jeu. 16 oct. 2025 23:30:08 CEST
**Database:** postgres
**Test Duration:** 30 seconds per test
**Concurrency:** 10 clients, 4 jobs

## Test Scenarios

1. **Single Row Lookup** - UUID-based single record retrieval (most common)
2. **Paginated Query** - 100 rows with OFFSET (GraphQL pagination pattern)
3. **Filtered Query** - WHERE clause with 100 row result
4. **Full Scan** - Complete table scan (worst case)
5. **Trinity Write** - INSERT with GENERATED column computation

---

## Results Summary


## Test 1: Single Row Lookup (UUID-based)

Most common query pattern in GraphQL - fetch single record by ID.

### jsonb_build_object (current)

- **TPS:**
- **Latency (avg):**  ms
- **Latency (stddev):**  ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
pgbench: error: client 6 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 3 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 5 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 7 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 9 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 8 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 0 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 2 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 1 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 4 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
transaction type: 01_test_single_row_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 0
number of failed transactions: 0 (NaN%)
pgbench: error: Run was aborted; the above results are incomplete.
```

</details>

### row_to_json with LATERAL

- **TPS:**
- **Latency (avg):**  ms
- **Latency (stddev):**  ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
pgbench: error: client 9 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 8 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 2 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 6 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 4 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 3 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 1 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 5 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 7 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 0 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
transaction type: 01_test_single_row_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 0
number of failed transactions: 0 (NaN%)
pgbench: error: Run was aborted; the above results are incomplete.
```

</details>

### row_to_json with subquery

- **TPS:**
- **Latency (avg):**  ms
- **Latency (stddev):**  ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
pgbench: error: client 5 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 7 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 0 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 6 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 1 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 8 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 4 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 9 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 3 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 2 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
transaction type: 01_test_single_row_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 0
number of failed transactions: 0 (NaN%)
pgbench: error: Run was aborted; the above results are incomplete.
```

</details>

### to_jsonb (simplest)

- **TPS:**
- **Latency (avg):**  ms
- **Latency (stddev):**  ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
pgbench: error: client 6 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 7 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 3 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 4 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 1 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 0 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 2 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 8 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 9 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
pgbench: error: client 5 script 0 aborted in command 2 query 0: ERROR:  syntax error at or near ":"
LINE 3: WHERE id = :'id';
                   ^
transaction type: 01_test_single_row_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 0
number of failed transactions: 0 (NaN%)
pgbench: error: Run was aborted; the above results are incomplete.
```

</details>


## Test 2: Paginated Query (100 rows)

Typical GraphQL pagination pattern - LIMIT 100 with random OFFSET.

### jsonb_build_object (current)

- **TPS:** 22.198113
- **Latency (avg):** 445.736 ms
- **Latency (stddev):** 326.349 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650215.374 s, 19.2 tps, lat 476.547 ms stddev 406.482, 0 failed
progress: 1760650220.375 s, 24.4 tps, lat 412.984 ms stddev 300.472, 0 failed
progress: 1760650225.374 s, 22.0 tps, lat 458.727 ms stddev 314.876, 0 failed
progress: 1760650230.373 s, 23.4 tps, lat 428.570 ms stddev 315.154, 0 failed
progress: 1760650235.374 s, 24.0 tps, lat 410.927 ms stddev 299.471, 0 failed
progress: 1760650240.373 s, 20.8 tps, lat 486.328 ms stddev 320.360, 0 failed
transaction type: 03_test_paginated_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 678
number of failed transactions: 0 (0.000%)
latency average = 445.736 ms
latency stddev = 326.349 ms
initial connection time = 52.958 ms
tps = 22.198113 (without initial connection time)
```

</details>

### row_to_json with LATERAL

- **TPS:** 11.676154
- **Latency (avg):** 851.866 ms
- **Latency (stddev):** 639.578 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650246.039 s, 10.6 tps, lat 778.782 ms stddev 487.108, 0 failed
progress: 1760650251.015 s, 16.3 tps, lat 666.509 ms stddev 521.820, 0 failed
progress: 1760650256.018 s, 13.6 tps, lat 709.969 ms stddev 462.986, 0 failed
progress: 1760650261.017 s, 8.6 tps, lat 955.257 ms stddev 708.810, 0 failed
progress: 1760650266.015 s, 9.0 tps, lat 1385.705 ms stddev 861.518, 0 failed
progress: 1760650271.015 s, 10.8 tps, lat 849.484 ms stddev 622.353, 0 failed
transaction type: 03_test_paginated_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 354
number of failed transactions: 0 (0.000%)
latency average = 851.866 ms
latency stddev = 639.578 ms
initial connection time = 23.206 ms
tps = 11.676154 (without initial connection time)
```

</details>

### row_to_json with subquery

- **TPS:** 12.584281
- **Latency (avg):** 788.700 ms
- **Latency (stddev):** 569.681 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650276.398 s, 12.2 tps, lat 684.191 ms stddev 501.842, 0 failed
progress: 1760650281.396 s, 10.8 tps, lat 864.505 ms stddev 514.566, 0 failed
progress: 1760650286.396 s, 15.8 tps, lat 742.772 ms stddev 570.003, 0 failed
progress: 1760650291.397 s, 11.4 tps, lat 794.162 ms stddev 525.443, 0 failed
progress: 1760650296.400 s, 11.4 tps, lat 889.650 ms stddev 741.575, 0 failed
progress: 1760650301.396 s, 13.2 tps, lat 747.448 ms stddev 514.952, 0 failed
transaction type: 03_test_paginated_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 384
number of failed transactions: 0 (0.000%)
latency average = 788.700 ms
latency stddev = 569.681 ms
initial connection time = 25.716 ms
tps = 12.584281 (without initial connection time)
```

</details>

### to_jsonb (simplest)

- **TPS:** 14.628768
- **Latency (avg):** 679.881 ms
- **Latency (stddev):** 543.783 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650306.979 s, 16.0 tps, lat 556.165 ms stddev 506.216, 0 failed
progress: 1760650311.979 s, 17.0 tps, lat 585.172 ms stddev 436.268, 0 failed
progress: 1760650316.979 s, 17.0 tps, lat 610.976 ms stddev 491.320, 0 failed
progress: 1760650321.981 s, 14.0 tps, lat 650.904 ms stddev 460.912, 0 failed
progress: 1760650327.036 s, 10.1 tps, lat 1005.937 ms stddev 684.863, 0 failed
progress: 1760650331.982 s, 12.7 tps, lat 793.352 ms stddev 628.507, 0 failed
transaction type: 03_test_paginated_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 444
number of failed transactions: 0 (0.000%)
latency average = 679.881 ms
latency stddev = 543.783 ms
initial connection time = 50.120 ms
tps = 14.628768 (without initial connection time)
```

</details>


## Test 3: Filtered Query

Query with WHERE clause returning ~100 active users.

### jsonb_build_object (current)

- **TPS:** 474.899793
- **Latency (avg):** 20.399 ms
- **Latency (stddev):** 31.485 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650337.448 s, 393.5 tps, lat 24.108 ms stddev 35.667, 0 failed
progress: 1760650342.447 s, 547.9 tps, lat 17.628 ms stddev 26.476, 0 failed
progress: 1760650347.447 s, 488.2 tps, lat 19.625 ms stddev 25.510, 0 failed
progress: 1760650352.447 s, 417.6 tps, lat 23.437 ms stddev 34.390, 0 failed
progress: 1760650357.447 s, 455.4 tps, lat 20.973 ms stddev 36.082, 0 failed
progress: 1760650362.453 s, 530.6 tps, lat 18.269 ms stddev 30.775, 0 failed
transaction type: 04_test_filtered_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 14179
number of failed transactions: 0 (0.000%)
latency average = 20.399 ms
latency stddev = 31.485 ms
initial connection time = 175.206 ms
tps = 474.899793 (without initial connection time)
```

</details>

### row_to_json with LATERAL

- **TPS:** 406.207028
- **Latency (avg):** 23.944 ms
- **Latency (stddev):** 37.035 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650367.540 s, 491.6 tps, lat 19.639 ms stddev 32.887, 0 failed
progress: 1760650372.561 s, 361.9 tps, lat 26.580 ms stddev 38.276, 0 failed
progress: 1760650377.528 s, 307.4 tps, lat 30.943 ms stddev 43.211, 0 failed
progress: 1760650382.528 s, 345.6 tps, lat 27.868 ms stddev 42.796, 0 failed
progress: 1760650387.528 s, 438.4 tps, lat 22.383 ms stddev 39.221, 0 failed
progress: 1760650392.528 s, 486.8 tps, lat 20.520 ms stddev 27.007, 0 failed
transaction type: 04_test_filtered_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 12171
number of failed transactions: 0 (0.000%)
latency average = 23.944 ms
latency stddev = 37.035 ms
initial connection time = 61.943 ms
tps = 406.207028 (without initial connection time)
```

</details>

### row_to_json with subquery

- **TPS:** 472.961087
- **Latency (avg):** 20.513 ms
- **Latency (stddev):** 32.124 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650397.609 s, 369.3 tps, lat 25.801 ms stddev 34.452, 0 failed
progress: 1760650402.612 s, 459.5 tps, lat 21.512 ms stddev 36.718, 0 failed
progress: 1760650407.613 s, 519.1 tps, lat 18.922 ms stddev 29.921, 0 failed
progress: 1760650412.608 s, 492.6 tps, lat 19.879 ms stddev 32.604, 0 failed
progress: 1760650417.617 s, 518.1 tps, lat 18.249 ms stddev 28.837, 0 failed
progress: 1760650422.608 s, 479.4 tps, lat 19.920 ms stddev 28.702, 0 failed
transaction type: 04_test_filtered_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 14201
number of failed transactions: 0 (0.000%)
latency average = 20.513 ms
latency stddev = 32.124 ms
initial connection time = 61.570 ms
tps = 472.961087 (without initial connection time)
```

</details>

### to_jsonb (simplest)

- **TPS:** 430.903201
- **Latency (avg):** 22.345 ms
- **Latency (stddev):** 33.882 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650427.786 s, 362.4 tps, lat 26.821 ms stddev 40.729, 0 failed
progress: 1760650432.825 s, 453.7 tps, lat 21.415 ms stddev 31.944, 0 failed
progress: 1760650437.786 s, 447.3 tps, lat 21.659 ms stddev 32.034, 0 failed
progress: 1760650442.787 s, 434.3 tps, lat 21.717 ms stddev 37.729, 0 failed
progress: 1760650447.787 s, 461.2 tps, lat 20.585 ms stddev 31.244, 0 failed
progress: 1760650452.786 s, 420.7 tps, lat 22.782 ms stddev 29.340, 0 failed
transaction type: 04_test_filtered_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 12907
number of failed transactions: 0 (0.000%)
latency average = 22.345 ms
latency stddev = 33.882 ms
initial connection time = 75.039 ms
tps = 430.903201 (without initial connection time)
```

</details>


## Test 4: Full Table Scan (10,000 rows)

Worst case scenario - SELECT all rows with JSONB generation.

### jsonb_build_object (current)

- **TPS:** 6.640483
- **Latency (avg):** 601.525 ms
- **Latency (stddev):** 204.855 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650457.912 s, 5.4 tps, lat 699.008 ms stddev 329.423, 0 failed
progress: 1760650462.905 s, 6.4 tps, lat 595.966 ms stddev 173.253, 0 failed
progress: 1760650467.906 s, 5.8 tps, lat 713.108 ms stddev 254.544, 0 failed
progress: 1760650472.905 s, 7.6 tps, lat 550.994 ms stddev 114.315, 0 failed
progress: 1760650477.905 s, 7.2 tps, lat 528.953 ms stddev 131.666, 0 failed
progress: 1760650482.906 s, 6.8 tps, lat 568.374 ms stddev 127.481, 0 failed
transaction type: 02_test_full_scan_temp.sql
scaling factor: 1
query mode: simple
number of clients: 4
number of threads: 2
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 200
number of failed transactions: 0 (0.000%)
latency average = 601.525 ms
latency stddev = 204.855 ms
initial connection time = 19.910 ms
tps = 6.640483 (without initial connection time)
```

</details>

### row_to_json with LATERAL

- **TPS:** 4.981490
- **Latency (avg):** 797.461 ms
- **Latency (stddev):** 272.005 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650488.186 s, 4.6 tps, lat 785.877 ms stddev 201.617, 0 failed
progress: 1760650493.186 s, 5.4 tps, lat 744.957 ms stddev 266.314, 0 failed
progress: 1760650498.186 s, 6.0 tps, lat 690.545 ms stddev 158.409, 0 failed
progress: 1760650503.186 s, 4.2 tps, lat 889.611 ms stddev 303.907, 0 failed
progress: 1760650508.186 s, 4.8 tps, lat 865.140 ms stddev 273.385, 0 failed
progress: 1760650513.186 s, 4.4 tps, lat 820.759 ms stddev 331.571, 0 failed
transaction type: 02_test_full_scan_temp.sql
scaling factor: 1
query mode: simple
number of clients: 4
number of threads: 2
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 151
number of failed transactions: 0 (0.000%)
latency average = 797.461 ms
latency stddev = 272.005 ms
initial connection time = 21.945 ms
tps = 4.981490 (without initial connection time)
```

</details>

### row_to_json with subquery

- **TPS:** 5.591493
- **Latency (avg):** 712.543 ms
- **Latency (stddev):** 310.615 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650518.590 s, 5.0 tps, lat 726.588 ms stddev 338.627, 0 failed
progress: 1760650523.588 s, 4.2 tps, lat 952.796 ms stddev 396.451, 0 failed
progress: 1760650528.588 s, 5.0 tps, lat 820.068 ms stddev 284.753, 0 failed
progress: 1760650533.588 s, 4.8 tps, lat 824.651 ms stddev 313.688, 0 failed
progress: 1760650538.588 s, 6.2 tps, lat 655.058 ms stddev 222.294, 0 failed
progress: 1760650543.588 s, 7.8 tps, lat 512.319 ms stddev 100.235, 0 failed
transaction type: 02_test_full_scan_temp.sql
scaling factor: 1
query mode: simple
number of clients: 4
number of threads: 2
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 169
number of failed transactions: 0 (0.000%)
latency average = 712.543 ms
latency stddev = 310.615 ms
initial connection time = 41.001 ms
tps = 5.591493 (without initial connection time)
```

</details>

### to_jsonb (simplest)

- **TPS:** 8.209083
- **Latency (avg):** 486.467 ms
- **Latency (stddev):** 155.301 ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
progress: 1760650548.885 s, 7.8 tps, lat 487.617 ms stddev 130.811, 0 failed
progress: 1760650553.885 s, 8.6 tps, lat 464.275 ms stddev 120.785, 0 failed
progress: 1760650558.885 s, 8.0 tps, lat 487.974 ms stddev 126.749, 0 failed
progress: 1760650563.885 s, 8.2 tps, lat 496.311 ms stddev 217.516, 0 failed
progress: 1760650568.886 s, 8.0 tps, lat 504.263 ms stddev 160.871, 0 failed
progress: 1760650573.886 s, 8.4 tps, lat 457.022 ms stddev 118.350, 0 failed
transaction type: 02_test_full_scan_temp.sql
scaling factor: 1
query mode: simple
number of clients: 4
number of threads: 2
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 249
number of failed transactions: 0 (0.000%)
latency average = 486.467 ms
latency stddev = 155.301 ms
initial connection time = 9.890 ms
tps = 8.209083 (without initial connection time)
```

</details>


## Test 5: Trinity Table Write Performance

INSERT performance with GENERATED JSONB column computation.

### Trinity with jsonb_build_object GENERATED

- **TPS:**
- **Latency (avg):**  ms
- **Latency (stddev):**  ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
pgbench: error: client 0 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 1 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 2 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 3 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 6 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 8 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 7 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 4 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 5 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
pgbench: error: client 9 script 0 aborted in command 1 query 0: ERROR:  relation "ttv_user_jsonb_build" does not exist
LINE 1: INSERT INTO ttv_user_jsonb_build (identifier, email, name, b...
                    ^
transaction type: 05_test_trinity_write_temp_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 0
number of failed transactions: 0 (NaN%)
pgbench: error: Run was aborted; the above results are incomplete.
```

</details>

### Trinity with to_jsonb GENERATED

- **TPS:**
- **Latency (avg):**  ms
- **Latency (stddev):**  ms

<details>
<summary>Full Output</summary>

```
pgbench (17.5)
starting vacuum...pgbench: error: ERROR:  relation "pgbench_branches" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_tellers" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
pgbench: error: ERROR:  relation "pgbench_history" does not exist
pgbench: detail: (ignoring this error and continuing anyway)
end.
pgbench: error: client 2 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 1 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 4 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 3 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 5 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 7 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 6 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 8 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 9 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
pgbench: error: client 0 script 0 aborted in command 1 query 0: ERROR:  relation "tv_user_to_jsonb" does not exist
LINE 1: INSERT INTO tv_user_to_jsonb (identifier, email, name, bio, ...
                    ^
transaction type: 05_test_trinity_write_temp_temp.sql
scaling factor: 1
query mode: simple
number of clients: 10
number of threads: 4
maximum number of tries: 1
duration: 30 s
number of transactions actually processed: 0
number of failed transactions: 0 (NaN%)
pgbench: error: Run was aborted; the above results are incomplete.
```

</details>


---

## Performance Comparison Summary

### Single Row Lookup (TPS)
| Method | TPS | vs Baseline |
|--------|-----|-------------|

---

## Storage Analysis

| Table | Total Size | Data Size | Index Size |
|-------|-----------|-----------|------------|

### Table Sizes


---

## Conclusions

### Key Findings

1. **Single Row Lookup Performance:**
   - Compare TPS values above to determine fastest method
   - Most critical metric for GraphQL APIs

2. **Bulk Query Performance:**
   - Paginated and filtered queries show scaling characteristics
   - Full scan tests maximum throughput

3. **Write Performance:**
   - Trinity tables with GENERATED columns show INSERT overhead
   - Compare jsonb_build_object vs to_jsonb generation cost

4. **Storage Efficiency:**
   - Generated columns add storage overhead
   - Indexes contribute significantly to total size

### Recommendations

Based on the benchmark results:
- **For Views:** Choose the method with best TPS/latency for your workload
- **For Trinity Tables:** Consider generation overhead vs query performance tradeoff
- **For Production:** Test with your actual data patterns and query complexity

---

**Benchmark completed:** jeu. 16 oct. 2025 23:36:14 CEST
