# Developer Documentation

Internal documentation for FraiseQL maintainers and contributors.

## 📁 Contents

### Architecture & Planning
- [Vision](architecture/vision.md) - Strategic direction and long-term goals
- [Component PRDs](architecture/component-prds.md) - Component specifications
- [Audiences](architecture/audiences.md) - Target user personas

### Release Management

- Release execution notes and historical plans

### Code Audits
- [Python Version Analysis](audits/python-version-analysis.md) - Python compatibility audits
- [Type Hinting Audit](audits/type-hinting-audit.md) - Type annotation coverage
- [Version Status](audits/version-status.md) - Current version status tracking

### Rust Extension
- [Implementation](rust/implementation.md) - Rust extension implementation notes
- [API](rust/api.md) - Rust extension API reference
- [Benchmarks](rust/benchmarks/) - Performance benchmark results

## 🔗 Related Documentation

- **User Documentation**: See [docs/](../docs/)
- **CI/CD Documentation**: See [.github/docs/](../.github/docs/)
- **Contributing Guide**: See [CONTRIBUTING.md](../CONTRIBUTING.md)
