# Archived Documentation

This directory contains historical and internal documentation that is no longer actively maintained but preserved for reference.

## Contents

### Strategic Planning Documents

**fraiseql_enterprise_gap_analysis.md** (22K)
- Comprehensive analysis of enterprise features missing from FraiseQL v0.11.5
- Created: Historical strategic planning document
- Status: Archived - feature gaps may no longer be current
- Use: Historical context for enterprise feature decisions

**ROADMAP.md** (3K)
- Historical product roadmap
- Status: May be outdated
- Use: Understanding historical project direction

### Internal Design Documents

**FAKE_DATA_GENERATOR_DESIGN.md** (14K)
- Design pattern for Trinity Identifier system (pk_*, id, identifier)
- Shows FK relationships and fake data generation patterns
- Status: Design pattern now documented in main docs
- Use: Reference for understanding Trinity pattern origins

**GETTING_STARTED.md** (6K)
- Original getting started navigation guide
- Status: Superseded by docs/README.md
- Use: Historical reference for documentation evolution

### Internal QA/Testing

**TESTING_CHECKLIST.md** (8K)
- Internal QA checklist
- Status: Archived internal tooling
- Use: Historical reference for testing approach

---

## Why These Were Archived

These documents served important purposes during FraiseQL's development but are no longer part of the primary user-facing documentation:

1. **Strategic documents** - Represent point-in-time analysis that may be outdated
2. **Design documents** - Patterns are now integrated into main documentation
3. **Internal processes** - QA checklists are internal tooling, not user documentation
4. **Redundant navigation** - Getting started is now handled by docs/README.md

---

## Looking for Current Documentation?

- **Getting Started**: See [docs/README.md](../README.md)
- **Quickstart**: See [docs/quickstart.md](../quickstart.md)
- **First Hour Tutorial**: See [docs/FIRST_HOUR.md](../FIRST_HOUR.md)
- **Core Concepts**: See [docs/core/concepts-glossary.md](../core/concepts-glossary.md)
- **Trinity Identifiers**: See [docs/patterns/trinity_identifiers.md](../patterns/trinity_identifiers.md)
- **Enterprise Features**: See [docs/enterprise/](../enterprise/)

---

**Note**: These files are preserved for historical context. If you need current information on any topic, please refer to the active documentation in the parent directories.
