# Migration Guide: v0.11 to v1

This guide covers the breaking changes and migration steps when upgrading from FraiseQL v0.11 to v1.

## Overview

FraiseQL v1 introduces a unified Rust-first architecture that removes legacy passthrough methods and simplifies the API. All database operations now use the same Rust-based implementation.

## Breaking Changes

### Removed Methods

The following methods have been removed from the database API:

- `find_raw_json()` - Use `find()` instead
- `find_one_raw_json()` - Use `find_one()` instead

### Removed Classes

- `PassthroughMixin` - No longer needed
- `RawJSONResult` - No longer needed

### Removed Attributes

- `mode` attribute on repositories - Architecture is now unified

## Migration Steps

### 1. Update Method Calls

Replace all calls to removed methods:

```python
# Before (v0.11)
result = await repository.find_raw_json("users", "data")
user = await repository.find_one_raw_json("users", "data", id=123)

# After (v1)
result = await repository.find("users")
user = await repository.find_one("users", id=123)
```

### 2. Remove Legacy Imports

Remove imports of deprecated classes:

```python
# Remove these imports
from fraiseql import PassthroughMixin, RawJSONResult
```

### 3. Update Repository Initialization

Remove any code that referenced the `mode` attribute:

```python
# Remove this type of code
if repository.mode == "rust":
    # special handling
```

### 4. Update Tests

Remove tests that specifically test the removed methods. All functionality is now covered by the unified `find()` and `find_one()` methods.

## Benefits

- **Simplified API**: Single set of methods for all database operations
- **Better Performance**: Unified Rust implementation for all queries
- **Easier Maintenance**: Less code duplication and complexity
- **Future-Proof**: Foundation for multi-language code generation

## Need Help?

If you encounter issues during migration, check:

1. All `find_raw_json` and `find_one_raw_json` calls have been replaced
2. No references to `PassthroughMixin` or `RawJSONResult` remain
3. Repository `mode` attribute references have been removed

The unified API maintains the same behavior for all existing use cases while providing better performance and maintainability.
