# Tutorials

Step-by-step learning paths and complete application examples.

## Learning Paths

### **[Beginner Learning Path](beginner-path.md)** 🎓

Structured progression from basics to building production applications.

**Duration**: 4-6 hours
**Prerequisites**: Completed [First Hour Guide](../getting-started/first-hour.md)

**Topics covered**:
- Database schema design
- Advanced filtering and pagination
- Authentication and authorization
- Error handling patterns
- Production deployment

---

### **[Interactive Examples](INTERACTIVE_EXAMPLES.md)** 💻

Side-by-side examples showing SQL → Python → GraphQL transformations.

**Duration**: 30 minutes
**Prerequisites**: Basic FraiseQL knowledge

**Examples**:
- Basic queries with JSONB views
- Filtered queries with arguments
- Nested object queries with JOINs
- Mutations with business logic
- Aggregation queries with table views

---

## Complete Application Tutorials

### **[Blog API](blog-api.md)** 📝

Build a complete blogging platform with users, posts, and comments.

**Duration**: 2-3 hours
**Level**: Intermediate

**Features**:
- User authentication
- Post creation and publishing
- Comment system
- Tag-based filtering
- Admin permissions

---

### **[Production Deployment](production-deployment.md)** 🚀

Deploy FraiseQL applications to production.

**Duration**: 1-2 hours
**Level**: Advanced

**Topics**:
- Docker containerization
- Database migrations
- Environment configuration
- Monitoring and logging
- Performance optimization

---

## Quick Navigation

**New to FraiseQL?**
Start with [Getting Started](../getting-started/) before diving into tutorials.

**Want hands-on practice?**
Try [Interactive Examples](INTERACTIVE_EXAMPLES.md) for quick, focused learning.

**Building a real app?**
Follow the [Blog API Tutorial](blog-api.md) for a complete walkthrough.

**Going to production?**
Check [Production Deployment](production-deployment.md) for deployment best practices.

## Related Documentation

- **[Getting Started](../getting-started/)** - Quickstart and first hour guides
- **[Core Concepts](../core/)** - Fundamental FraiseQL concepts
- **[Guides](../guides/)** - Task-based guides for specific workflows
- **[Examples](../../examples/)** - Working code examples
