from setuptools import setup, find_packages
import os

# read the description file for pypi
# using utf-8 encoding to support chinese characters
with open("DESCRIPTION.md", "r", encoding="utf-8") as f:
    long_description = f.read()

setup(
    name="terminal-markdown",
    version="1.0.0",
    description="terminal-markdown: a cli tool to render markdown with pos tagging.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="User",
    packages=find_packages(),
    install_requires=[
        "rich>=13.0.0",
        "nltk>=3.8.0",
    ],
    entry_points={
        "console_scripts": [
            "tmd=tmd.cli:main",
        ],
    },
    python_requires=">=3.7",
)
