"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from polar_sdk.customer_session_sdk import CustomerSessionSDK
from polar_sdk.downloadables import Downloadables
from polar_sdk.polar_benefit_grants import PolarBenefitGrants
from polar_sdk.polar_customer_meters import PolarCustomerMeters
from polar_sdk.polar_customers import PolarCustomers
from polar_sdk.polar_license_keys import PolarLicenseKeys
from polar_sdk.polar_orders import PolarOrders
from polar_sdk.polar_organizations import PolarOrganizations
from polar_sdk.polar_subscriptions import PolarSubscriptions
from polar_sdk.seats import Seats
from typing import Optional


class CustomerPortal(BaseSDK):
    benefit_grants: PolarBenefitGrants
    customers: PolarCustomers
    customer_meters: PolarCustomerMeters
    seats: Seats
    customer_session: CustomerSessionSDK
    downloadables: Downloadables
    license_keys: PolarLicenseKeys
    orders: PolarOrders
    organizations: PolarOrganizations
    subscriptions: PolarSubscriptions

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.benefit_grants = PolarBenefitGrants(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.customers = PolarCustomers(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.customer_meters = PolarCustomerMeters(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.seats = Seats(self.sdk_configuration, parent_ref=self.parent_ref)
        self.customer_session = CustomerSessionSDK(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.downloadables = Downloadables(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.license_keys = PolarLicenseKeys(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.orders = PolarOrders(self.sdk_configuration, parent_ref=self.parent_ref)
        self.organizations = PolarOrganizations(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.subscriptions = PolarSubscriptions(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
