"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefitgrantsortproperty import BenefitGrantSortProperty
from .listresource_benefitgrant_ import (
    ListResourceBenefitGrant,
    ListResourceBenefitGrantTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


BenefitGrantsListQueryParamOrganizationIDFilterTypedDict = TypeAliasType(
    "BenefitGrantsListQueryParamOrganizationIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by organization ID."""


BenefitGrantsListQueryParamOrganizationIDFilter = TypeAliasType(
    "BenefitGrantsListQueryParamOrganizationIDFilter", Union[str, List[str]]
)
r"""Filter by organization ID."""


BenefitGrantsListQueryParamCustomerIDFilterTypedDict = TypeAliasType(
    "BenefitGrantsListQueryParamCustomerIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by customer ID."""


BenefitGrantsListQueryParamCustomerIDFilter = TypeAliasType(
    "BenefitGrantsListQueryParamCustomerIDFilter", Union[str, List[str]]
)
r"""Filter by customer ID."""


class BenefitGrantsListRequestTypedDict(TypedDict):
    organization_id: NotRequired[
        Nullable[BenefitGrantsListQueryParamOrganizationIDFilterTypedDict]
    ]
    r"""Filter by organization ID."""
    customer_id: NotRequired[
        Nullable[BenefitGrantsListQueryParamCustomerIDFilterTypedDict]
    ]
    r"""Filter by customer ID."""
    is_granted: NotRequired[Nullable[bool]]
    r"""Filter by granted status. If `true`, only granted benefits will be returned. If `false`, only revoked benefits will be returned."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""
    sorting: NotRequired[Nullable[List[BenefitGrantSortProperty]]]
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""


class BenefitGrantsListRequest(BaseModel):
    organization_id: Annotated[
        OptionalNullable[BenefitGrantsListQueryParamOrganizationIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    customer_id: Annotated[
        OptionalNullable[BenefitGrantsListQueryParamCustomerIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by customer ID."""

    is_granted: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by granted status. If `true`, only granted benefits will be returned. If `false`, only revoked benefits will be returned."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    sorting: Annotated[
        OptionalNullable[List[BenefitGrantSortProperty]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "organization_id",
            "customer_id",
            "is_granted",
            "page",
            "limit",
            "sorting",
        ]
        nullable_fields = ["organization_id", "customer_id", "is_granted", "sorting"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class BenefitGrantsListResponseTypedDict(TypedDict):
    result: ListResourceBenefitGrantTypedDict


class BenefitGrantsListResponse(BaseModel):
    next: Callable[[], Optional[BenefitGrantsListResponse]]

    result: ListResourceBenefitGrant
