"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefitcustom import BenefitCustom, BenefitCustomTypedDict
from .benefitgrantcustomproperties import (
    BenefitGrantCustomProperties,
    BenefitGrantCustomPropertiesTypedDict,
)
from .benefitgranterror import BenefitGrantError, BenefitGrantErrorTypedDict
from .customer import Customer, CustomerTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class BenefitGrantCustomWebhookTypedDict(TypedDict):
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the grant."""
    is_granted: bool
    r"""Whether the benefit is granted."""
    is_revoked: bool
    r"""Whether the benefit is revoked."""
    subscription_id: Nullable[str]
    r"""The ID of the subscription that granted this benefit."""
    order_id: Nullable[str]
    r"""The ID of the order that granted this benefit."""
    customer_id: str
    r"""The ID of the customer concerned by this grant."""
    benefit_id: str
    r"""The ID of the benefit concerned by this grant."""
    customer: CustomerTypedDict
    r"""A customer in an organization."""
    benefit: BenefitCustomTypedDict
    r"""A benefit of type `custom`.

    Use it to grant any kind of benefit that doesn't fit in the other types.
    """
    properties: BenefitGrantCustomPropertiesTypedDict
    granted_at: NotRequired[Nullable[datetime]]
    r"""The timestamp when the benefit was granted. If `None`, the benefit is not granted."""
    revoked_at: NotRequired[Nullable[datetime]]
    r"""The timestamp when the benefit was revoked. If `None`, the benefit is not revoked."""
    error: NotRequired[Nullable[BenefitGrantErrorTypedDict]]
    r"""The error information if the benefit grant failed with an unrecoverable error."""
    previous_properties: NotRequired[Nullable[BenefitGrantCustomPropertiesTypedDict]]


class BenefitGrantCustomWebhook(BaseModel):
    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the grant."""

    is_granted: bool
    r"""Whether the benefit is granted."""

    is_revoked: bool
    r"""Whether the benefit is revoked."""

    subscription_id: Nullable[str]
    r"""The ID of the subscription that granted this benefit."""

    order_id: Nullable[str]
    r"""The ID of the order that granted this benefit."""

    customer_id: str
    r"""The ID of the customer concerned by this grant."""

    benefit_id: str
    r"""The ID of the benefit concerned by this grant."""

    customer: Customer
    r"""A customer in an organization."""

    benefit: BenefitCustom
    r"""A benefit of type `custom`.

    Use it to grant any kind of benefit that doesn't fit in the other types.
    """

    properties: BenefitGrantCustomProperties

    granted_at: OptionalNullable[datetime] = UNSET
    r"""The timestamp when the benefit was granted. If `None`, the benefit is not granted."""

    revoked_at: OptionalNullable[datetime] = UNSET
    r"""The timestamp when the benefit was revoked. If `None`, the benefit is not revoked."""

    error: OptionalNullable[BenefitGrantError] = UNSET
    r"""The error information if the benefit grant failed with an unrecoverable error."""

    previous_properties: OptionalNullable[BenefitGrantCustomProperties] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["granted_at", "revoked_at", "error", "previous_properties"]
        nullable_fields = [
            "modified_at",
            "granted_at",
            "revoked_at",
            "subscription_id",
            "order_id",
            "error",
            "previous_properties",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
