"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .addressinput import AddressInput, AddressInputTypedDict
from .trialinterval import TrialInterval
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


CheckoutUpdateCustomFieldDataTypedDict = TypeAliasType(
    "CheckoutUpdateCustomFieldDataTypedDict", Union[str, int, bool, datetime]
)


CheckoutUpdateCustomFieldData = TypeAliasType(
    "CheckoutUpdateCustomFieldData", Union[str, int, bool, datetime]
)


CheckoutUpdateMetadataTypedDict = TypeAliasType(
    "CheckoutUpdateMetadataTypedDict", Union[str, int, float, bool]
)


CheckoutUpdateMetadata = TypeAliasType(
    "CheckoutUpdateMetadata", Union[str, int, float, bool]
)


CheckoutUpdateCustomerMetadataTypedDict = TypeAliasType(
    "CheckoutUpdateCustomerMetadataTypedDict", Union[str, int, float, bool]
)


CheckoutUpdateCustomerMetadata = TypeAliasType(
    "CheckoutUpdateCustomerMetadata", Union[str, int, float, bool]
)


class CheckoutUpdateTypedDict(TypedDict):
    r"""Update an existing checkout session using an access token."""

    custom_field_data: NotRequired[
        Dict[str, Nullable[CheckoutUpdateCustomFieldDataTypedDict]]
    ]
    r"""Key-value object storing custom field values."""
    product_id: NotRequired[Nullable[str]]
    r"""ID of the product to checkout. Must be present in the checkout's product list."""
    product_price_id: NotRequired[Nullable[str]]
    r"""ID of the product price to checkout. Must correspond to a price present in the checkout's product list."""
    amount: NotRequired[Nullable[int]]
    seats: NotRequired[Nullable[int]]
    r"""Number of seats for seat-based pricing."""
    is_business_customer: NotRequired[Nullable[bool]]
    customer_name: NotRequired[Nullable[str]]
    customer_email: NotRequired[Nullable[str]]
    customer_billing_name: NotRequired[Nullable[str]]
    customer_billing_address: NotRequired[Nullable[AddressInputTypedDict]]
    customer_tax_id: NotRequired[Nullable[str]]
    trial_interval: NotRequired[Nullable[TrialInterval]]
    r"""The interval unit for the trial period."""
    trial_interval_count: NotRequired[Nullable[int]]
    r"""The number of interval units for the trial period."""
    metadata: NotRequired[Dict[str, CheckoutUpdateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    discount_id: NotRequired[Nullable[str]]
    r"""ID of the discount to apply to the checkout."""
    allow_discount_codes: NotRequired[Nullable[bool]]
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""
    require_billing_address: NotRequired[Nullable[bool]]
    r"""Whether to require the customer to fill their full billing address, instead of just the country. Customers in the US will always be required to fill their full address, regardless of this setting. If you preset the billing address, this setting will be automatically set to `true`."""
    customer_ip_address: NotRequired[Nullable[str]]
    customer_metadata: NotRequired[
        Nullable[Dict[str, CheckoutUpdateCustomerMetadataTypedDict]]
    ]
    r"""Key-value object allowing you to store additional information that'll be copied to the created customer.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    success_url: NotRequired[Nullable[str]]
    r"""URL where the customer will be redirected after a successful payment.You can add the `checkout_id={CHECKOUT_ID}` query parameter to retrieve the checkout session id."""
    return_url: NotRequired[Nullable[str]]
    r"""When set, a back button will be shown in the checkout to return to this URL."""
    embed_origin: NotRequired[Nullable[str]]
    r"""If you plan to embed the checkout session, set this to the Origin of the embedding page. It'll allow the Polar iframe to communicate with the parent page."""


class CheckoutUpdate(BaseModel):
    r"""Update an existing checkout session using an access token."""

    custom_field_data: Optional[Dict[str, Nullable[CheckoutUpdateCustomFieldData]]] = (
        None
    )
    r"""Key-value object storing custom field values."""

    product_id: OptionalNullable[str] = UNSET
    r"""ID of the product to checkout. Must be present in the checkout's product list."""

    product_price_id: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""ID of the product price to checkout. Must correspond to a price present in the checkout's product list."""

    amount: OptionalNullable[int] = UNSET

    seats: OptionalNullable[int] = UNSET
    r"""Number of seats for seat-based pricing."""

    is_business_customer: OptionalNullable[bool] = UNSET

    customer_name: OptionalNullable[str] = UNSET

    customer_email: OptionalNullable[str] = UNSET

    customer_billing_name: OptionalNullable[str] = UNSET

    customer_billing_address: OptionalNullable[AddressInput] = UNSET

    customer_tax_id: OptionalNullable[str] = UNSET

    trial_interval: OptionalNullable[TrialInterval] = UNSET
    r"""The interval unit for the trial period."""

    trial_interval_count: OptionalNullable[int] = UNSET
    r"""The number of interval units for the trial period."""

    metadata: Optional[Dict[str, CheckoutUpdateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    discount_id: OptionalNullable[str] = UNSET
    r"""ID of the discount to apply to the checkout."""

    allow_discount_codes: OptionalNullable[bool] = UNSET
    r"""Whether to allow the customer to apply discount codes. If you apply a discount through `discount_id`, it'll still be applied, but the customer won't be able to change it."""

    require_billing_address: OptionalNullable[bool] = UNSET
    r"""Whether to require the customer to fill their full billing address, instead of just the country. Customers in the US will always be required to fill their full address, regardless of this setting. If you preset the billing address, this setting will be automatically set to `true`."""

    customer_ip_address: OptionalNullable[str] = UNSET

    customer_metadata: OptionalNullable[Dict[str, CheckoutUpdateCustomerMetadata]] = (
        UNSET
    )
    r"""Key-value object allowing you to store additional information that'll be copied to the created customer.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    success_url: OptionalNullable[str] = UNSET
    r"""URL where the customer will be redirected after a successful payment.You can add the `checkout_id={CHECKOUT_ID}` query parameter to retrieve the checkout session id."""

    return_url: OptionalNullable[str] = UNSET
    r"""When set, a back button will be shown in the checkout to return to this URL."""

    embed_origin: OptionalNullable[str] = UNSET
    r"""If you plan to embed the checkout session, set this to the Origin of the embedding page. It'll allow the Polar iframe to communicate with the parent page."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "custom_field_data",
            "product_id",
            "product_price_id",
            "amount",
            "seats",
            "is_business_customer",
            "customer_name",
            "customer_email",
            "customer_billing_name",
            "customer_billing_address",
            "customer_tax_id",
            "trial_interval",
            "trial_interval_count",
            "metadata",
            "discount_id",
            "allow_discount_codes",
            "require_billing_address",
            "customer_ip_address",
            "customer_metadata",
            "success_url",
            "return_url",
            "embed_origin",
        ]
        nullable_fields = [
            "product_id",
            "product_price_id",
            "amount",
            "seats",
            "is_business_customer",
            "customer_name",
            "customer_email",
            "customer_billing_name",
            "customer_billing_address",
            "customer_tax_id",
            "trial_interval",
            "trial_interval_count",
            "discount_id",
            "allow_discount_codes",
            "require_billing_address",
            "customer_ip_address",
            "customer_metadata",
            "success_url",
            "return_url",
            "embed_origin",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
