"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .addressinput import AddressInput, AddressInputTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


CheckoutUpdatePublicCustomFieldDataTypedDict = TypeAliasType(
    "CheckoutUpdatePublicCustomFieldDataTypedDict", Union[str, int, bool, datetime]
)


CheckoutUpdatePublicCustomFieldData = TypeAliasType(
    "CheckoutUpdatePublicCustomFieldData", Union[str, int, bool, datetime]
)


class CheckoutUpdatePublicTypedDict(TypedDict):
    r"""Update an existing checkout session using the client secret."""

    custom_field_data: NotRequired[
        Dict[str, Nullable[CheckoutUpdatePublicCustomFieldDataTypedDict]]
    ]
    r"""Key-value object storing custom field values."""
    product_id: NotRequired[Nullable[str]]
    r"""ID of the product to checkout. Must be present in the checkout's product list."""
    product_price_id: NotRequired[Nullable[str]]
    r"""ID of the product price to checkout. Must correspond to a price present in the checkout's product list."""
    amount: NotRequired[Nullable[int]]
    seats: NotRequired[Nullable[int]]
    r"""Number of seats for seat-based pricing."""
    is_business_customer: NotRequired[Nullable[bool]]
    customer_name: NotRequired[Nullable[str]]
    customer_email: NotRequired[Nullable[str]]
    customer_billing_name: NotRequired[Nullable[str]]
    customer_billing_address: NotRequired[Nullable[AddressInputTypedDict]]
    customer_tax_id: NotRequired[Nullable[str]]
    discount_code: NotRequired[Nullable[str]]
    r"""Discount code to apply to the checkout."""


class CheckoutUpdatePublic(BaseModel):
    r"""Update an existing checkout session using the client secret."""

    custom_field_data: Optional[
        Dict[str, Nullable[CheckoutUpdatePublicCustomFieldData]]
    ] = None
    r"""Key-value object storing custom field values."""

    product_id: OptionalNullable[str] = UNSET
    r"""ID of the product to checkout. Must be present in the checkout's product list."""

    product_price_id: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET
    r"""ID of the product price to checkout. Must correspond to a price present in the checkout's product list."""

    amount: OptionalNullable[int] = UNSET

    seats: OptionalNullable[int] = UNSET
    r"""Number of seats for seat-based pricing."""

    is_business_customer: OptionalNullable[bool] = UNSET

    customer_name: OptionalNullable[str] = UNSET

    customer_email: OptionalNullable[str] = UNSET

    customer_billing_name: OptionalNullable[str] = UNSET

    customer_billing_address: OptionalNullable[AddressInput] = UNSET

    customer_tax_id: OptionalNullable[str] = UNSET

    discount_code: OptionalNullable[str] = UNSET
    r"""Discount code to apply to the checkout."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "custom_field_data",
            "product_id",
            "product_price_id",
            "amount",
            "seats",
            "is_business_customer",
            "customer_name",
            "customer_email",
            "customer_billing_name",
            "customer_billing_address",
            "customer_tax_id",
            "discount_code",
        ]
        nullable_fields = [
            "product_id",
            "product_price_id",
            "amount",
            "seats",
            "is_business_customer",
            "customer_name",
            "customer_email",
            "customer_billing_name",
            "customer_billing_address",
            "customer_tax_id",
            "discount_code",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
