"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customermetersortproperty import CustomerMeterSortProperty
from .listresource_customermeter_ import (
    ListResourceCustomerMeter,
    ListResourceCustomerMeterTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


CustomerMetersListQueryParamOrganizationIDFilterTypedDict = TypeAliasType(
    "CustomerMetersListQueryParamOrganizationIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by organization ID."""


CustomerMetersListQueryParamOrganizationIDFilter = TypeAliasType(
    "CustomerMetersListQueryParamOrganizationIDFilter", Union[str, List[str]]
)
r"""Filter by organization ID."""


CustomerMetersListQueryParamCustomerIDFilterTypedDict = TypeAliasType(
    "CustomerMetersListQueryParamCustomerIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by customer ID."""


CustomerMetersListQueryParamCustomerIDFilter = TypeAliasType(
    "CustomerMetersListQueryParamCustomerIDFilter", Union[str, List[str]]
)
r"""Filter by customer ID."""


CustomerMetersListQueryParamExternalCustomerIDFilterTypedDict = TypeAliasType(
    "CustomerMetersListQueryParamExternalCustomerIDFilterTypedDict",
    Union[str, List[str]],
)
r"""Filter by external customer ID."""


CustomerMetersListQueryParamExternalCustomerIDFilter = TypeAliasType(
    "CustomerMetersListQueryParamExternalCustomerIDFilter", Union[str, List[str]]
)
r"""Filter by external customer ID."""


QueryParamMeterIDFilterTypedDict = TypeAliasType(
    "QueryParamMeterIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by meter ID."""


QueryParamMeterIDFilter = TypeAliasType(
    "QueryParamMeterIDFilter", Union[str, List[str]]
)
r"""Filter by meter ID."""


class CustomerMetersListRequestTypedDict(TypedDict):
    organization_id: NotRequired[
        Nullable[CustomerMetersListQueryParamOrganizationIDFilterTypedDict]
    ]
    r"""Filter by organization ID."""
    customer_id: NotRequired[
        Nullable[CustomerMetersListQueryParamCustomerIDFilterTypedDict]
    ]
    r"""Filter by customer ID."""
    external_customer_id: NotRequired[
        Nullable[CustomerMetersListQueryParamExternalCustomerIDFilterTypedDict]
    ]
    r"""Filter by external customer ID."""
    meter_id: NotRequired[Nullable[QueryParamMeterIDFilterTypedDict]]
    r"""Filter by meter ID."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""
    sorting: NotRequired[Nullable[List[CustomerMeterSortProperty]]]
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""


class CustomerMetersListRequest(BaseModel):
    organization_id: Annotated[
        OptionalNullable[CustomerMetersListQueryParamOrganizationIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    customer_id: Annotated[
        OptionalNullable[CustomerMetersListQueryParamCustomerIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by customer ID."""

    external_customer_id: Annotated[
        OptionalNullable[CustomerMetersListQueryParamExternalCustomerIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by external customer ID."""

    meter_id: Annotated[
        OptionalNullable[QueryParamMeterIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by meter ID."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    sorting: Annotated[
        OptionalNullable[List[CustomerMeterSortProperty]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "organization_id",
            "customer_id",
            "external_customer_id",
            "meter_id",
            "page",
            "limit",
            "sorting",
        ]
        nullable_fields = [
            "organization_id",
            "customer_id",
            "external_customer_id",
            "meter_id",
            "sorting",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomerMetersListResponseTypedDict(TypedDict):
    result: ListResourceCustomerMeterTypedDict


class CustomerMetersListResponse(BaseModel):
    next: Callable[[], Optional[CustomerMetersListResponse]]

    result: ListResourceCustomerMeter
