"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefittype import BenefitType
from .customerbenefitgrantsortproperty import CustomerBenefitGrantSortProperty
from .listresource_customerbenefitgrant_ import (
    ListResourceCustomerBenefitGrant,
    ListResourceCustomerBenefitGrantTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata, SecurityMetadata
import pydantic
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CustomerPortalBenefitGrantsListSecurityTypedDict(TypedDict):
    customer_session: str


class CustomerPortalBenefitGrantsListSecurity(BaseModel):
    customer_session: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]


QueryParamBenefitTypeFilterTypedDict = TypeAliasType(
    "QueryParamBenefitTypeFilterTypedDict", Union[BenefitType, List[BenefitType]]
)
r"""Filter by benefit type."""


QueryParamBenefitTypeFilter = TypeAliasType(
    "QueryParamBenefitTypeFilter", Union[BenefitType, List[BenefitType]]
)
r"""Filter by benefit type."""


CustomerPortalBenefitGrantsListQueryParamBenefitIDFilterTypedDict = TypeAliasType(
    "CustomerPortalBenefitGrantsListQueryParamBenefitIDFilterTypedDict",
    Union[str, List[str]],
)
r"""Filter by benefit ID."""


CustomerPortalBenefitGrantsListQueryParamBenefitIDFilter = TypeAliasType(
    "CustomerPortalBenefitGrantsListQueryParamBenefitIDFilter", Union[str, List[str]]
)
r"""Filter by benefit ID."""


CustomerPortalBenefitGrantsListQueryParamOrganizationIDFilterTypedDict = TypeAliasType(
    "CustomerPortalBenefitGrantsListQueryParamOrganizationIDFilterTypedDict",
    Union[str, List[str]],
)
r"""Filter by organization ID."""


CustomerPortalBenefitGrantsListQueryParamOrganizationIDFilter = TypeAliasType(
    "CustomerPortalBenefitGrantsListQueryParamOrganizationIDFilter",
    Union[str, List[str]],
)
r"""Filter by organization ID."""


QueryParamCheckoutIDFilterTypedDict = TypeAliasType(
    "QueryParamCheckoutIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by checkout ID."""


QueryParamCheckoutIDFilter = TypeAliasType(
    "QueryParamCheckoutIDFilter", Union[str, List[str]]
)
r"""Filter by checkout ID."""


QueryParamOrderIDFilterTypedDict = TypeAliasType(
    "QueryParamOrderIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by order ID."""


QueryParamOrderIDFilter = TypeAliasType(
    "QueryParamOrderIDFilter", Union[str, List[str]]
)
r"""Filter by order ID."""


QueryParamSubscriptionIDFilterTypedDict = TypeAliasType(
    "QueryParamSubscriptionIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by subscription ID."""


QueryParamSubscriptionIDFilter = TypeAliasType(
    "QueryParamSubscriptionIDFilter", Union[str, List[str]]
)
r"""Filter by subscription ID."""


class CustomerPortalBenefitGrantsListRequestTypedDict(TypedDict):
    type_filter: NotRequired[Nullable[QueryParamBenefitTypeFilterTypedDict]]
    r"""Filter by benefit type."""
    benefit_id: NotRequired[
        Nullable[CustomerPortalBenefitGrantsListQueryParamBenefitIDFilterTypedDict]
    ]
    r"""Filter by benefit ID."""
    organization_id: NotRequired[
        Nullable[CustomerPortalBenefitGrantsListQueryParamOrganizationIDFilterTypedDict]
    ]
    r"""Filter by organization ID."""
    checkout_id: NotRequired[Nullable[QueryParamCheckoutIDFilterTypedDict]]
    r"""Filter by checkout ID."""
    order_id: NotRequired[Nullable[QueryParamOrderIDFilterTypedDict]]
    r"""Filter by order ID."""
    subscription_id: NotRequired[Nullable[QueryParamSubscriptionIDFilterTypedDict]]
    r"""Filter by subscription ID."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""
    sorting: NotRequired[Nullable[List[CustomerBenefitGrantSortProperty]]]
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""


class CustomerPortalBenefitGrantsListRequest(BaseModel):
    type_filter: Annotated[
        OptionalNullable[QueryParamBenefitTypeFilter],
        pydantic.Field(alias="type"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by benefit type."""

    benefit_id: Annotated[
        OptionalNullable[CustomerPortalBenefitGrantsListQueryParamBenefitIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by benefit ID."""

    organization_id: Annotated[
        OptionalNullable[CustomerPortalBenefitGrantsListQueryParamOrganizationIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    checkout_id: Annotated[
        OptionalNullable[QueryParamCheckoutIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by checkout ID."""

    order_id: Annotated[
        OptionalNullable[QueryParamOrderIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by order ID."""

    subscription_id: Annotated[
        OptionalNullable[QueryParamSubscriptionIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by subscription ID."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    sorting: Annotated[
        OptionalNullable[List[CustomerBenefitGrantSortProperty]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type_filter",
            "benefit_id",
            "organization_id",
            "checkout_id",
            "order_id",
            "subscription_id",
            "page",
            "limit",
            "sorting",
        ]
        nullable_fields = [
            "type_filter",
            "benefit_id",
            "organization_id",
            "checkout_id",
            "order_id",
            "subscription_id",
            "sorting",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomerPortalBenefitGrantsListResponseTypedDict(TypedDict):
    result: ListResourceCustomerBenefitGrantTypedDict


class CustomerPortalBenefitGrantsListResponse(BaseModel):
    next: Callable[[], Optional[CustomerPortalBenefitGrantsListResponse]]

    result: ListResourceCustomerBenefitGrant
