"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customerordersortproperty import CustomerOrderSortProperty
from .listresource_customerorder_ import (
    ListResourceCustomerOrder,
    ListResourceCustomerOrderTypedDict,
)
from .productbillingtype import ProductBillingType
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata, SecurityMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CustomerPortalOrdersListSecurityTypedDict(TypedDict):
    customer_session: str


class CustomerPortalOrdersListSecurity(BaseModel):
    customer_session: Annotated[
        str,
        FieldMetadata(
            security=SecurityMetadata(
                scheme=True,
                scheme_type="http",
                sub_type="bearer",
                field_name="Authorization",
            )
        ),
    ]


CustomerPortalOrdersListQueryParamOrganizationIDFilterTypedDict = TypeAliasType(
    "CustomerPortalOrdersListQueryParamOrganizationIDFilterTypedDict",
    Union[str, List[str]],
)
r"""Filter by organization ID."""


CustomerPortalOrdersListQueryParamOrganizationIDFilter = TypeAliasType(
    "CustomerPortalOrdersListQueryParamOrganizationIDFilter", Union[str, List[str]]
)
r"""Filter by organization ID."""


CustomerPortalOrdersListQueryParamProductIDFilterTypedDict = TypeAliasType(
    "CustomerPortalOrdersListQueryParamProductIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by product ID."""


CustomerPortalOrdersListQueryParamProductIDFilter = TypeAliasType(
    "CustomerPortalOrdersListQueryParamProductIDFilter", Union[str, List[str]]
)
r"""Filter by product ID."""


CustomerPortalOrdersListQueryParamProductBillingTypeFilterTypedDict = TypeAliasType(
    "CustomerPortalOrdersListQueryParamProductBillingTypeFilterTypedDict",
    Union[ProductBillingType, List[ProductBillingType]],
)
r"""Filter by product billing type. `recurring` will filter data corresponding to subscriptions creations or renewals. `one_time` will filter data corresponding to one-time purchases."""


CustomerPortalOrdersListQueryParamProductBillingTypeFilter = TypeAliasType(
    "CustomerPortalOrdersListQueryParamProductBillingTypeFilter",
    Union[ProductBillingType, List[ProductBillingType]],
)
r"""Filter by product billing type. `recurring` will filter data corresponding to subscriptions creations or renewals. `one_time` will filter data corresponding to one-time purchases."""


CustomerPortalOrdersListQueryParamSubscriptionIDFilterTypedDict = TypeAliasType(
    "CustomerPortalOrdersListQueryParamSubscriptionIDFilterTypedDict",
    Union[str, List[str]],
)
r"""Filter by subscription ID."""


CustomerPortalOrdersListQueryParamSubscriptionIDFilter = TypeAliasType(
    "CustomerPortalOrdersListQueryParamSubscriptionIDFilter", Union[str, List[str]]
)
r"""Filter by subscription ID."""


class CustomerPortalOrdersListRequestTypedDict(TypedDict):
    organization_id: NotRequired[
        Nullable[CustomerPortalOrdersListQueryParamOrganizationIDFilterTypedDict]
    ]
    r"""Filter by organization ID."""
    product_id: NotRequired[
        Nullable[CustomerPortalOrdersListQueryParamProductIDFilterTypedDict]
    ]
    r"""Filter by product ID."""
    product_billing_type: NotRequired[
        Nullable[CustomerPortalOrdersListQueryParamProductBillingTypeFilterTypedDict]
    ]
    r"""Filter by product billing type. `recurring` will filter data corresponding to subscriptions creations or renewals. `one_time` will filter data corresponding to one-time purchases."""
    subscription_id: NotRequired[
        Nullable[CustomerPortalOrdersListQueryParamSubscriptionIDFilterTypedDict]
    ]
    r"""Filter by subscription ID."""
    query: NotRequired[Nullable[str]]
    r"""Search by product or organization name."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""
    sorting: NotRequired[Nullable[List[CustomerOrderSortProperty]]]
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""


class CustomerPortalOrdersListRequest(BaseModel):
    organization_id: Annotated[
        OptionalNullable[CustomerPortalOrdersListQueryParamOrganizationIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    product_id: Annotated[
        OptionalNullable[CustomerPortalOrdersListQueryParamProductIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by product ID."""

    product_billing_type: Annotated[
        OptionalNullable[CustomerPortalOrdersListQueryParamProductBillingTypeFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by product billing type. `recurring` will filter data corresponding to subscriptions creations or renewals. `one_time` will filter data corresponding to one-time purchases."""

    subscription_id: Annotated[
        OptionalNullable[CustomerPortalOrdersListQueryParamSubscriptionIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by subscription ID."""

    query: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Search by product or organization name."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    sorting: Annotated[
        OptionalNullable[List[CustomerOrderSortProperty]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "organization_id",
            "product_id",
            "product_billing_type",
            "subscription_id",
            "query",
            "page",
            "limit",
            "sorting",
        ]
        nullable_fields = [
            "organization_id",
            "product_id",
            "product_billing_type",
            "subscription_id",
            "query",
            "sorting",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CustomerPortalOrdersListResponseTypedDict(TypedDict):
    result: ListResourceCustomerOrderTypedDict


class CustomerPortalOrdersListResponse(BaseModel):
    next: Callable[[], Optional[CustomerPortalOrdersListResponse]]

    result: ListResourceCustomerOrder
