"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class CustomerOrderPaymentConfirmationTypedDict(TypedDict):
    r"""Response after confirming a retry payment."""

    status: str
    r"""Payment status after confirmation."""
    client_secret: NotRequired[Nullable[str]]
    r"""Client secret for handling additional actions."""
    error: NotRequired[Nullable[str]]
    r"""Error message if confirmation failed."""


class CustomerOrderPaymentConfirmation(BaseModel):
    r"""Response after confirming a retry payment."""

    status: str
    r"""Payment status after confirmation."""

    client_secret: OptionalNullable[str] = UNSET
    r"""Client secret for handling additional actions."""

    error: OptionalNullable[str] = UNSET
    r"""Error message if confirmation failed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["client_secret", "error"]
        nullable_fields = ["client_secret", "error"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
