"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .seatstatus import SeatStatus
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class CustomerSeatTypedDict(TypedDict):
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The seat ID"""
    subscription_id: str
    r"""The subscription ID"""
    status: SeatStatus
    customer_id: NotRequired[Nullable[str]]
    r"""The assigned customer ID"""
    customer_email: NotRequired[Nullable[str]]
    r"""The assigned customer email"""
    invitation_token_expires_at: NotRequired[Nullable[datetime]]
    r"""When the invitation token expires"""
    claimed_at: NotRequired[Nullable[datetime]]
    r"""When the seat was claimed"""
    revoked_at: NotRequired[Nullable[datetime]]
    r"""When the seat was revoked"""
    seat_metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Additional metadata for the seat"""


class CustomerSeat(BaseModel):
    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The seat ID"""

    subscription_id: str
    r"""The subscription ID"""

    status: SeatStatus

    customer_id: OptionalNullable[str] = UNSET
    r"""The assigned customer ID"""

    customer_email: OptionalNullable[str] = UNSET
    r"""The assigned customer email"""

    invitation_token_expires_at: OptionalNullable[datetime] = UNSET
    r"""When the invitation token expires"""

    claimed_at: OptionalNullable[datetime] = UNSET
    r"""When the seat was claimed"""

    revoked_at: OptionalNullable[datetime] = UNSET
    r"""When the seat was revoked"""

    seat_metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Additional metadata for the seat"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "customer_id",
            "customer_email",
            "invitation_token_expires_at",
            "claimed_at",
            "revoked_at",
            "seat_metadata",
        ]
        nullable_fields = [
            "modified_at",
            "customer_id",
            "customer_email",
            "invitation_token_expires_at",
            "claimed_at",
            "revoked_at",
            "seat_metadata",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
