"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .benefitgrantcustomproperties import (
    BenefitGrantCustomProperties,
    BenefitGrantCustomPropertiesTypedDict,
)
from .benefitgrantdiscordproperties import (
    BenefitGrantDiscordProperties,
    BenefitGrantDiscordPropertiesTypedDict,
)
from .benefitgrantdownloadablesproperties import (
    BenefitGrantDownloadablesProperties,
    BenefitGrantDownloadablesPropertiesTypedDict,
)
from .benefitgrantgithubrepositoryproperties import (
    BenefitGrantGitHubRepositoryProperties,
    BenefitGrantGitHubRepositoryPropertiesTypedDict,
)
from .benefitgrantlicensekeysproperties import (
    BenefitGrantLicenseKeysProperties,
    BenefitGrantLicenseKeysPropertiesTypedDict,
)
from .benefittype import BenefitType
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, Union
from typing_extensions import TypeAliasType, TypedDict


BenefitMetadataTypedDict = TypeAliasType(
    "BenefitMetadataTypedDict", Union[str, int, float, bool]
)


BenefitMetadata = TypeAliasType("BenefitMetadata", Union[str, int, float, bool])


CustomerStateBenefitGrantPropertiesTypedDict = TypeAliasType(
    "CustomerStateBenefitGrantPropertiesTypedDict",
    Union[
        BenefitGrantCustomPropertiesTypedDict,
        BenefitGrantDownloadablesPropertiesTypedDict,
        BenefitGrantLicenseKeysPropertiesTypedDict,
        BenefitGrantDiscordPropertiesTypedDict,
        BenefitGrantGitHubRepositoryPropertiesTypedDict,
    ],
)


CustomerStateBenefitGrantProperties = TypeAliasType(
    "CustomerStateBenefitGrantProperties",
    Union[
        BenefitGrantCustomProperties,
        BenefitGrantDownloadablesProperties,
        BenefitGrantLicenseKeysProperties,
        BenefitGrantDiscordProperties,
        BenefitGrantGitHubRepositoryProperties,
    ],
)


class CustomerStateBenefitGrantTypedDict(TypedDict):
    r"""An active benefit grant for a customer."""

    id: str
    r"""The ID of the grant."""
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    granted_at: datetime
    r"""The timestamp when the benefit was granted."""
    benefit_id: str
    r"""The ID of the benefit concerned by this grant."""
    benefit_type: BenefitType
    benefit_metadata: Dict[str, BenefitMetadataTypedDict]
    r"""The metadata of the benefit concerned by this grant."""
    properties: CustomerStateBenefitGrantPropertiesTypedDict


class CustomerStateBenefitGrant(BaseModel):
    r"""An active benefit grant for a customer."""

    id: str
    r"""The ID of the grant."""

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    granted_at: datetime
    r"""The timestamp when the benefit was granted."""

    benefit_id: str
    r"""The ID of the benefit concerned by this grant."""

    benefit_type: BenefitType

    benefit_metadata: Dict[str, BenefitMetadata]
    r"""The metadata of the benefit concerned by this grant."""

    properties: CustomerStateBenefitGrantProperties

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["modified_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
