"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customerstatesubscriptionmeter import (
    CustomerStateSubscriptionMeter,
    CustomerStateSubscriptionMeterTypedDict,
)
from .subscriptionrecurringinterval import SubscriptionRecurringInterval
from datetime import datetime
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


CustomerStateSubscriptionCustomFieldDataTypedDict = TypeAliasType(
    "CustomerStateSubscriptionCustomFieldDataTypedDict", Union[str, int, bool, datetime]
)


CustomerStateSubscriptionCustomFieldData = TypeAliasType(
    "CustomerStateSubscriptionCustomFieldData", Union[str, int, bool, datetime]
)


CustomerStateSubscriptionMetadataTypedDict = TypeAliasType(
    "CustomerStateSubscriptionMetadataTypedDict", Union[str, int, float, bool]
)


CustomerStateSubscriptionMetadata = TypeAliasType(
    "CustomerStateSubscriptionMetadata", Union[str, int, float, bool]
)


class CustomerStateSubscriptionStatus(str, Enum):
    ACTIVE = "active"
    TRIALING = "trialing"


class CustomerStateSubscriptionTypedDict(TypedDict):
    r"""An active customer subscription."""

    id: str
    r"""The ID of the subscription."""
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    metadata: Dict[str, CustomerStateSubscriptionMetadataTypedDict]
    status: CustomerStateSubscriptionStatus
    amount: int
    r"""The amount of the subscription."""
    currency: str
    r"""The currency of the subscription."""
    recurring_interval: SubscriptionRecurringInterval
    current_period_start: datetime
    r"""The start timestamp of the current billing period."""
    current_period_end: Nullable[datetime]
    r"""The end timestamp of the current billing period."""
    trial_start: Nullable[datetime]
    r"""The start timestamp of the trial period, if any."""
    trial_end: Nullable[datetime]
    r"""The end timestamp of the trial period, if any."""
    cancel_at_period_end: bool
    r"""Whether the subscription will be canceled at the end of the current period."""
    canceled_at: Nullable[datetime]
    r"""The timestamp when the subscription was canceled. The subscription might still be active if `cancel_at_period_end` is `true`."""
    started_at: Nullable[datetime]
    r"""The timestamp when the subscription started."""
    ends_at: Nullable[datetime]
    r"""The timestamp when the subscription will end."""
    product_id: str
    r"""The ID of the subscribed product."""
    discount_id: Nullable[str]
    r"""The ID of the applied discount, if any."""
    meters: List[CustomerStateSubscriptionMeterTypedDict]
    r"""List of meters associated with the subscription."""
    custom_field_data: NotRequired[
        Dict[str, Nullable[CustomerStateSubscriptionCustomFieldDataTypedDict]]
    ]
    r"""Key-value object storing custom field values."""


class CustomerStateSubscription(BaseModel):
    r"""An active customer subscription."""

    id: str
    r"""The ID of the subscription."""

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    metadata: Dict[str, CustomerStateSubscriptionMetadata]

    status: CustomerStateSubscriptionStatus

    amount: int
    r"""The amount of the subscription."""

    currency: str
    r"""The currency of the subscription."""

    recurring_interval: SubscriptionRecurringInterval

    current_period_start: datetime
    r"""The start timestamp of the current billing period."""

    current_period_end: Nullable[datetime]
    r"""The end timestamp of the current billing period."""

    trial_start: Nullable[datetime]
    r"""The start timestamp of the trial period, if any."""

    trial_end: Nullable[datetime]
    r"""The end timestamp of the trial period, if any."""

    cancel_at_period_end: bool
    r"""Whether the subscription will be canceled at the end of the current period."""

    canceled_at: Nullable[datetime]
    r"""The timestamp when the subscription was canceled. The subscription might still be active if `cancel_at_period_end` is `true`."""

    started_at: Nullable[datetime]
    r"""The timestamp when the subscription started."""

    ends_at: Nullable[datetime]
    r"""The timestamp when the subscription will end."""

    product_id: str
    r"""The ID of the subscribed product."""

    discount_id: Nullable[str]
    r"""The ID of the applied discount, if any."""

    meters: List[CustomerStateSubscriptionMeter]
    r"""List of meters associated with the subscription."""

    custom_field_data: Optional[
        Dict[str, Nullable[CustomerStateSubscriptionCustomFieldData]]
    ] = None
    r"""Key-value object storing custom field values."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["custom_field_data"]
        nullable_fields = [
            "modified_at",
            "current_period_end",
            "trial_start",
            "trial_end",
            "canceled_at",
            "started_at",
            "ends_at",
            "discount_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
