"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .eventmetadatainput import EventMetadataInput, EventMetadataInputTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, Optional
from typing_extensions import NotRequired, TypedDict


class EventCreateCustomerTypedDict(TypedDict):
    name: str
    r"""The name of the event."""
    customer_id: str
    r"""ID of the customer in your Polar organization associated with the event."""
    timestamp: NotRequired[datetime]
    r"""The timestamp of the event."""
    organization_id: NotRequired[Nullable[str]]
    r"""The ID of the organization owning the event. **Required unless you use an organization token.**"""
    metadata: NotRequired[Dict[str, EventMetadataInputTypedDict]]


class EventCreateCustomer(BaseModel):
    name: str
    r"""The name of the event."""

    customer_id: str
    r"""ID of the customer in your Polar organization associated with the event."""

    timestamp: Optional[datetime] = None
    r"""The timestamp of the event."""

    organization_id: OptionalNullable[str] = UNSET
    r"""The ID of the organization owning the event. **Required unless you use an organization token.**"""

    metadata: Optional[Dict[str, EventMetadataInput]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["timestamp", "organization_id", "metadata"]
        nullable_fields = ["organization_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
