"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .paymentprocessor import PaymentProcessor
from .paymentstatus import PaymentStatus
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Dict, Optional
from typing_extensions import NotRequired, TypedDict


class GenericPaymentTypedDict(TypedDict):
    r"""Schema of a payment with a generic payment method."""

    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    processor: PaymentProcessor
    status: PaymentStatus
    amount: int
    r"""The payment amount in cents."""
    currency: str
    r"""The payment currency. Currently, only `usd` is supported."""
    method: str
    r"""The payment method used."""
    decline_reason: Nullable[str]
    r"""Error code, if the payment was declined."""
    decline_message: Nullable[str]
    r"""Human-reasable error message, if the payment was declined."""
    organization_id: str
    r"""The ID of the organization that owns the payment."""
    checkout_id: Nullable[str]
    r"""The ID of the checkout session associated with this payment."""
    order_id: Nullable[str]
    r"""The ID of the order associated with this payment."""
    processor_metadata: NotRequired[Dict[str, Any]]
    r"""Additional metadata from the payment processor for internal use."""


class GenericPayment(BaseModel):
    r"""Schema of a payment with a generic payment method."""

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    processor: PaymentProcessor

    status: PaymentStatus

    amount: int
    r"""The payment amount in cents."""

    currency: str
    r"""The payment currency. Currently, only `usd` is supported."""

    method: str
    r"""The payment method used."""

    decline_reason: Nullable[str]
    r"""Error code, if the payment was declined."""

    decline_message: Nullable[str]
    r"""Human-reasable error message, if the payment was declined."""

    organization_id: str
    r"""The ID of the organization that owns the payment."""

    checkout_id: Nullable[str]
    r"""The ID of the checkout session associated with this payment."""

    order_id: Nullable[str]
    r"""The ID of the order associated with this payment."""

    processor_metadata: Optional[Dict[str, Any]] = None
    r"""Additional metadata from the payment processor for internal use."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["processor_metadata"]
        nullable_fields = [
            "modified_at",
            "decline_reason",
            "decline_message",
            "checkout_id",
            "order_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
