"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel
from typing import Dict, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


LicenseKeyActivateConditionsTypedDict = TypeAliasType(
    "LicenseKeyActivateConditionsTypedDict", Union[str, int, float, bool]
)


LicenseKeyActivateConditions = TypeAliasType(
    "LicenseKeyActivateConditions", Union[str, int, float, bool]
)


LicenseKeyActivateMetaTypedDict = TypeAliasType(
    "LicenseKeyActivateMetaTypedDict", Union[str, int, float, bool]
)


LicenseKeyActivateMeta = TypeAliasType(
    "LicenseKeyActivateMeta", Union[str, int, float, bool]
)


class LicenseKeyActivateTypedDict(TypedDict):
    key: str
    organization_id: str
    label: str
    conditions: NotRequired[Dict[str, LicenseKeyActivateConditionsTypedDict]]
    r"""Key-value object allowing you to set conditions that must match when validating the license key.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    meta: NotRequired[Dict[str, LicenseKeyActivateMetaTypedDict]]
    r"""Key-value object allowing you to store additional information about the activation

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """


class LicenseKeyActivate(BaseModel):
    key: str

    organization_id: str

    label: str

    conditions: Optional[Dict[str, LicenseKeyActivateConditions]] = None
    r"""Key-value object allowing you to set conditions that must match when validating the license key.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    meta: Optional[Dict[str, LicenseKeyActivateMeta]] = None
    r"""Key-value object allowing you to store additional information about the activation

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
