"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


ConditionsTypedDict = TypeAliasType("ConditionsTypedDict", Union[str, int, float, bool])


Conditions = TypeAliasType("Conditions", Union[str, int, float, bool])


class LicenseKeyValidateTypedDict(TypedDict):
    key: str
    organization_id: str
    activation_id: NotRequired[Nullable[str]]
    benefit_id: NotRequired[Nullable[str]]
    customer_id: NotRequired[Nullable[str]]
    increment_usage: NotRequired[Nullable[int]]
    conditions: NotRequired[Dict[str, ConditionsTypedDict]]
    r"""Key-value object allowing you to set conditions that must match when validating the license key.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """


class LicenseKeyValidate(BaseModel):
    key: str

    organization_id: str

    activation_id: OptionalNullable[str] = UNSET

    benefit_id: OptionalNullable[str] = UNSET

    customer_id: OptionalNullable[str] = UNSET

    increment_usage: OptionalNullable[int] = UNSET

    conditions: Optional[Dict[str, Conditions]] = None
    r"""Key-value object allowing you to set conditions that must match when validating the license key.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "activation_id",
            "benefit_id",
            "customer_id",
            "increment_usage",
            "conditions",
        ]
        nullable_fields = [
            "activation_id",
            "benefit_id",
            "customer_id",
            "increment_usage",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
