"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .countaggregation import CountAggregation, CountAggregationTypedDict
from .filter_ import Filter, FilterTypedDict
from .propertyaggregation import PropertyAggregation, PropertyAggregationTypedDict
from .uniqueaggregation import UniqueAggregation, UniqueAggregationTypedDict
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import get_discriminator
import pydantic
from pydantic import Discriminator, Tag, model_serializer
from typing import Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


MeterUpdateMetadataTypedDict = TypeAliasType(
    "MeterUpdateMetadataTypedDict", Union[str, int, float, bool]
)


MeterUpdateMetadata = TypeAliasType("MeterUpdateMetadata", Union[str, int, float, bool])


AggregationTypedDict = TypeAliasType(
    "AggregationTypedDict",
    Union[
        CountAggregationTypedDict,
        PropertyAggregationTypedDict,
        UniqueAggregationTypedDict,
    ],
)


Aggregation = Annotated[
    Union[
        Annotated[PropertyAggregation, Tag("avg")],
        Annotated[CountAggregation, Tag("count")],
        Annotated[PropertyAggregation, Tag("max")],
        Annotated[PropertyAggregation, Tag("min")],
        Annotated[PropertyAggregation, Tag("sum")],
        Annotated[UniqueAggregation, Tag("unique")],
    ],
    Discriminator(lambda m: get_discriminator(m, "func", "func")),
]


class MeterUpdateTypedDict(TypedDict):
    metadata: NotRequired[Dict[str, MeterUpdateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    name: NotRequired[Nullable[str]]
    r"""The name of the meter. Will be shown on customer's invoices and usage."""
    filter_: NotRequired[Nullable[FilterTypedDict]]
    r"""The filter to apply on events that'll be used to calculate the meter."""
    aggregation: NotRequired[Nullable[AggregationTypedDict]]
    r"""The aggregation to apply on the filtered events to calculate the meter."""
    is_archived: NotRequired[Nullable[bool]]
    r"""Whether the meter is archived. Archived meters are no longer used for billing."""


class MeterUpdate(BaseModel):
    metadata: Optional[Dict[str, MeterUpdateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    name: OptionalNullable[str] = UNSET
    r"""The name of the meter. Will be shown on customer's invoices and usage."""

    filter_: Annotated[OptionalNullable[Filter], pydantic.Field(alias="filter")] = UNSET
    r"""The filter to apply on events that'll be used to calculate the meter."""

    aggregation: OptionalNullable[Aggregation] = UNSET
    r"""The aggregation to apply on the filtered events to calculate the meter."""

    is_archived: OptionalNullable[bool] = UNSET
    r"""Whether the meter is archived. Archived meters are no longer used for billing."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["metadata", "name", "filter", "aggregation", "is_archived"]
        nullable_fields = ["name", "filter", "aggregation", "is_archived"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
