"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .organizationcustomeremailsettings import (
    OrganizationCustomerEmailSettings,
    OrganizationCustomerEmailSettingsTypedDict,
)
from .organizationdetails import OrganizationDetails, OrganizationDetailsTypedDict
from .organizationfeaturesettings import (
    OrganizationFeatureSettings,
    OrganizationFeatureSettingsTypedDict,
)
from .organizationnotificationsettings import (
    OrganizationNotificationSettings,
    OrganizationNotificationSettingsTypedDict,
)
from .organizationsociallink import (
    OrganizationSocialLink,
    OrganizationSocialLinkTypedDict,
)
from .organizationsubscriptionsettings import (
    OrganizationSubscriptionSettings,
    OrganizationSubscriptionSettingsTypedDict,
)
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class OrganizationCreateTypedDict(TypedDict):
    name: str
    slug: str
    avatar_url: NotRequired[Nullable[str]]
    email: NotRequired[Nullable[str]]
    r"""Public support email."""
    website: NotRequired[Nullable[str]]
    r"""Official website of the organization."""
    socials: NotRequired[Nullable[List[OrganizationSocialLinkTypedDict]]]
    r"""Link to social profiles."""
    details: NotRequired[Nullable[OrganizationDetailsTypedDict]]
    r"""Additional, private, business details Polar needs about active organizations for compliance (KYC)."""
    feature_settings: NotRequired[Nullable[OrganizationFeatureSettingsTypedDict]]
    subscription_settings: NotRequired[
        Nullable[OrganizationSubscriptionSettingsTypedDict]
    ]
    notification_settings: NotRequired[
        Nullable[OrganizationNotificationSettingsTypedDict]
    ]
    customer_email_settings: NotRequired[
        Nullable[OrganizationCustomerEmailSettingsTypedDict]
    ]


class OrganizationCreate(BaseModel):
    name: str

    slug: str

    avatar_url: OptionalNullable[str] = UNSET

    email: OptionalNullable[str] = UNSET
    r"""Public support email."""

    website: OptionalNullable[str] = UNSET
    r"""Official website of the organization."""

    socials: OptionalNullable[List[OrganizationSocialLink]] = UNSET
    r"""Link to social profiles."""

    details: OptionalNullable[OrganizationDetails] = UNSET
    r"""Additional, private, business details Polar needs about active organizations for compliance (KYC)."""

    feature_settings: OptionalNullable[OrganizationFeatureSettings] = UNSET

    subscription_settings: OptionalNullable[OrganizationSubscriptionSettings] = UNSET

    notification_settings: OptionalNullable[OrganizationNotificationSettings] = UNSET

    customer_email_settings: OptionalNullable[OrganizationCustomerEmailSettings] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "avatar_url",
            "email",
            "website",
            "socials",
            "details",
            "feature_settings",
            "subscription_settings",
            "notification_settings",
            "customer_email_settings",
        ]
        nullable_fields = [
            "avatar_url",
            "email",
            "website",
            "socials",
            "details",
            "feature_settings",
            "subscription_settings",
            "notification_settings",
            "customer_email_settings",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
