"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .listresource_ import ListResource, ListResourceTypedDict
from .paymentsortproperty import PaymentSortProperty
from .paymentstatus import PaymentStatus
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PaymentsListQueryParamOrganizationIDFilterTypedDict = TypeAliasType(
    "PaymentsListQueryParamOrganizationIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by organization ID."""


PaymentsListQueryParamOrganizationIDFilter = TypeAliasType(
    "PaymentsListQueryParamOrganizationIDFilter", Union[str, List[str]]
)
r"""Filter by organization ID."""


PaymentsListQueryParamCheckoutIDFilterTypedDict = TypeAliasType(
    "PaymentsListQueryParamCheckoutIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by checkout ID."""


PaymentsListQueryParamCheckoutIDFilter = TypeAliasType(
    "PaymentsListQueryParamCheckoutIDFilter", Union[str, List[str]]
)
r"""Filter by checkout ID."""


PaymentsListQueryParamOrderIDFilterTypedDict = TypeAliasType(
    "PaymentsListQueryParamOrderIDFilterTypedDict", Union[str, List[str]]
)
r"""Filter by order ID."""


PaymentsListQueryParamOrderIDFilter = TypeAliasType(
    "PaymentsListQueryParamOrderIDFilter", Union[str, List[str]]
)
r"""Filter by order ID."""


QueryParamStatusFilterTypedDict = TypeAliasType(
    "QueryParamStatusFilterTypedDict", Union[PaymentStatus, List[PaymentStatus]]
)
r"""Filter by payment status."""


QueryParamStatusFilter = TypeAliasType(
    "QueryParamStatusFilter", Union[PaymentStatus, List[PaymentStatus]]
)
r"""Filter by payment status."""


MethodFilterTypedDict = TypeAliasType("MethodFilterTypedDict", Union[str, List[str]])
r"""Filter by payment method."""


MethodFilter = TypeAliasType("MethodFilter", Union[str, List[str]])
r"""Filter by payment method."""


CustomerEmailFilterTypedDict = TypeAliasType(
    "CustomerEmailFilterTypedDict", Union[str, List[str]]
)
r"""Filter by customer email."""


CustomerEmailFilter = TypeAliasType("CustomerEmailFilter", Union[str, List[str]])
r"""Filter by customer email."""


class PaymentsListRequestTypedDict(TypedDict):
    organization_id: NotRequired[
        Nullable[PaymentsListQueryParamOrganizationIDFilterTypedDict]
    ]
    r"""Filter by organization ID."""
    checkout_id: NotRequired[Nullable[PaymentsListQueryParamCheckoutIDFilterTypedDict]]
    r"""Filter by checkout ID."""
    order_id: NotRequired[Nullable[PaymentsListQueryParamOrderIDFilterTypedDict]]
    r"""Filter by order ID."""
    status: NotRequired[Nullable[QueryParamStatusFilterTypedDict]]
    r"""Filter by payment status."""
    method: NotRequired[Nullable[MethodFilterTypedDict]]
    r"""Filter by payment method."""
    customer_email: NotRequired[Nullable[CustomerEmailFilterTypedDict]]
    r"""Filter by customer email."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""
    sorting: NotRequired[Nullable[List[PaymentSortProperty]]]
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""


class PaymentsListRequest(BaseModel):
    organization_id: Annotated[
        OptionalNullable[PaymentsListQueryParamOrganizationIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    checkout_id: Annotated[
        OptionalNullable[PaymentsListQueryParamCheckoutIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by checkout ID."""

    order_id: Annotated[
        OptionalNullable[PaymentsListQueryParamOrderIDFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by order ID."""

    status: Annotated[
        OptionalNullable[QueryParamStatusFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by payment status."""

    method: Annotated[
        OptionalNullable[MethodFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by payment method."""

    customer_email: Annotated[
        OptionalNullable[CustomerEmailFilter],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by customer email."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    sorting: Annotated[
        OptionalNullable[List[PaymentSortProperty]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Sorting criterion. Several criteria can be used simultaneously and will be applied in order. Add a minus sign `-` before the criteria name to sort by descending order."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "organization_id",
            "checkout_id",
            "order_id",
            "status",
            "method",
            "customer_email",
            "page",
            "limit",
            "sorting",
        ]
        nullable_fields = [
            "organization_id",
            "checkout_id",
            "order_id",
            "status",
            "method",
            "customer_email",
            "sorting",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsListResponseTypedDict(TypedDict):
    result: ListResourceTypedDict


class PaymentsListResponse(BaseModel):
    next: Callable[[], Optional[PaymentsListResponse]]

    result: ListResource
