"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachedcustomfieldcreate import (
    AttachedCustomFieldCreate,
    AttachedCustomFieldCreateTypedDict,
)
from .productpricecustomcreate import (
    ProductPriceCustomCreate,
    ProductPriceCustomCreateTypedDict,
)
from .productpricefixedcreate import (
    ProductPriceFixedCreate,
    ProductPriceFixedCreateTypedDict,
)
from .productpricefreecreate import (
    ProductPriceFreeCreate,
    ProductPriceFreeCreateTypedDict,
)
from .productpricemeteredunitcreate import (
    ProductPriceMeteredUnitCreate,
    ProductPriceMeteredUnitCreateTypedDict,
)
from .productpriceseatbasedcreate import (
    ProductPriceSeatBasedCreate,
    ProductPriceSeatBasedCreateTypedDict,
)
from .subscriptionrecurringinterval import SubscriptionRecurringInterval
from .trialinterval import TrialInterval
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import get_discriminator
from pydantic import Discriminator, Tag, model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ProductCreateRecurringMetadataTypedDict = TypeAliasType(
    "ProductCreateRecurringMetadataTypedDict", Union[str, int, float, bool]
)


ProductCreateRecurringMetadata = TypeAliasType(
    "ProductCreateRecurringMetadata", Union[str, int, float, bool]
)


ProductCreateRecurringPricesTypedDict = TypeAliasType(
    "ProductCreateRecurringPricesTypedDict",
    Union[
        ProductPriceFreeCreateTypedDict,
        ProductPriceFixedCreateTypedDict,
        ProductPriceSeatBasedCreateTypedDict,
        ProductPriceCustomCreateTypedDict,
        ProductPriceMeteredUnitCreateTypedDict,
    ],
)


ProductCreateRecurringPrices = Annotated[
    Union[
        Annotated[ProductPriceCustomCreate, Tag("custom")],
        Annotated[ProductPriceFixedCreate, Tag("fixed")],
        Annotated[ProductPriceFreeCreate, Tag("free")],
        Annotated[ProductPriceMeteredUnitCreate, Tag("metered_unit")],
        Annotated[ProductPriceSeatBasedCreate, Tag("seat_based")],
    ],
    Discriminator(lambda m: get_discriminator(m, "amount_type", "amount_type")),
]


class ProductCreateRecurringTypedDict(TypedDict):
    name: str
    r"""The name of the product."""
    prices: List[ProductCreateRecurringPricesTypedDict]
    r"""List of available prices for this product. It should contain at most one static price (fixed, custom or free), and any number of metered prices. Metered prices are not supported on one-time purchase products."""
    recurring_interval: SubscriptionRecurringInterval
    metadata: NotRequired[Dict[str, ProductCreateRecurringMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    description: NotRequired[Nullable[str]]
    r"""The description of the product."""
    medias: NotRequired[Nullable[List[str]]]
    r"""List of file IDs. Each one must be on the same organization as the product, of type `product_media` and correctly uploaded."""
    attached_custom_fields: NotRequired[List[AttachedCustomFieldCreateTypedDict]]
    r"""List of custom fields to attach."""
    organization_id: NotRequired[Nullable[str]]
    r"""The ID of the organization owning the product. **Required unless you use an organization token.**"""
    trial_interval: NotRequired[Nullable[TrialInterval]]
    r"""The interval unit for the trial period."""
    trial_interval_count: NotRequired[Nullable[int]]
    r"""The number of interval units for the trial period."""


class ProductCreateRecurring(BaseModel):
    name: str
    r"""The name of the product."""

    prices: List[ProductCreateRecurringPrices]
    r"""List of available prices for this product. It should contain at most one static price (fixed, custom or free), and any number of metered prices. Metered prices are not supported on one-time purchase products."""

    recurring_interval: SubscriptionRecurringInterval

    metadata: Optional[Dict[str, ProductCreateRecurringMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    description: OptionalNullable[str] = UNSET
    r"""The description of the product."""

    medias: OptionalNullable[List[str]] = UNSET
    r"""List of file IDs. Each one must be on the same organization as the product, of type `product_media` and correctly uploaded."""

    attached_custom_fields: Optional[List[AttachedCustomFieldCreate]] = None
    r"""List of custom fields to attach."""

    organization_id: OptionalNullable[str] = UNSET
    r"""The ID of the organization owning the product. **Required unless you use an organization token.**"""

    trial_interval: OptionalNullable[TrialInterval] = UNSET
    r"""The interval unit for the trial period."""

    trial_interval_count: OptionalNullable[int] = UNSET
    r"""The number of interval units for the trial period."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "metadata",
            "description",
            "medias",
            "attached_custom_fields",
            "organization_id",
            "trial_interval",
            "trial_interval_count",
        ]
        nullable_fields = [
            "description",
            "medias",
            "organization_id",
            "trial_interval",
            "trial_interval_count",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
