"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .productpriceseattiers import ProductPriceSeatTiers, ProductPriceSeatTiersTypedDict
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductPriceSeatBasedCreateTypedDict(TypedDict):
    r"""Schema to create a seat-based price with volume-based tiers."""

    seat_tiers: ProductPriceSeatTiersTypedDict
    r"""List of pricing tiers for seat-based pricing."""
    amount_type: Literal["seat_based"]
    price_currency: NotRequired[str]
    r"""The currency. Currently, only `usd` is supported."""


class ProductPriceSeatBasedCreate(BaseModel):
    r"""Schema to create a seat-based price with volume-based tiers."""

    seat_tiers: ProductPriceSeatTiers
    r"""List of pricing tiers for seat-based pricing."""

    AMOUNT_TYPE: Annotated[
        Annotated[Literal["seat_based"], AfterValidator(validate_const("seat_based"))],
        pydantic.Field(alias="amount_type"),
    ] = "seat_based"

    price_currency: Optional[str] = "usd"
    r"""The currency. Currently, only `usd` is supported."""
