"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachedcustomfieldcreate import (
    AttachedCustomFieldCreate,
    AttachedCustomFieldCreateTypedDict,
)
from .existingproductprice import ExistingProductPrice, ExistingProductPriceTypedDict
from .productpricecustomcreate import (
    ProductPriceCustomCreate,
    ProductPriceCustomCreateTypedDict,
)
from .productpricefixedcreate import (
    ProductPriceFixedCreate,
    ProductPriceFixedCreateTypedDict,
)
from .productpricefreecreate import (
    ProductPriceFreeCreate,
    ProductPriceFreeCreateTypedDict,
)
from .productpricemeteredunitcreate import (
    ProductPriceMeteredUnitCreate,
    ProductPriceMeteredUnitCreateTypedDict,
)
from .productpriceseatbasedcreate import (
    ProductPriceSeatBasedCreate,
    ProductPriceSeatBasedCreateTypedDict,
)
from .subscriptionrecurringinterval import SubscriptionRecurringInterval
from .trialinterval import TrialInterval
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import get_discriminator
from pydantic import Discriminator, Tag, model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


ProductUpdateMetadataTypedDict = TypeAliasType(
    "ProductUpdateMetadataTypedDict", Union[str, int, float, bool]
)


ProductUpdateMetadata = TypeAliasType(
    "ProductUpdateMetadata", Union[str, int, float, bool]
)


TwoTypedDict = TypeAliasType(
    "TwoTypedDict",
    Union[
        ProductPriceFreeCreateTypedDict,
        ProductPriceFixedCreateTypedDict,
        ProductPriceSeatBasedCreateTypedDict,
        ProductPriceCustomCreateTypedDict,
        ProductPriceMeteredUnitCreateTypedDict,
    ],
)


Two = Annotated[
    Union[
        Annotated[ProductPriceCustomCreate, Tag("custom")],
        Annotated[ProductPriceFixedCreate, Tag("fixed")],
        Annotated[ProductPriceFreeCreate, Tag("free")],
        Annotated[ProductPriceMeteredUnitCreate, Tag("metered_unit")],
        Annotated[ProductPriceSeatBasedCreate, Tag("seat_based")],
    ],
    Discriminator(lambda m: get_discriminator(m, "amount_type", "amount_type")),
]


ProductUpdatePricesTypedDict = TypeAliasType(
    "ProductUpdatePricesTypedDict", Union[ExistingProductPriceTypedDict, TwoTypedDict]
)


ProductUpdatePrices = TypeAliasType(
    "ProductUpdatePrices", Union[ExistingProductPrice, Two]
)


class ProductUpdateTypedDict(TypedDict):
    r"""Schema to update a product."""

    metadata: NotRequired[Dict[str, ProductUpdateMetadataTypedDict]]
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """
    trial_interval: NotRequired[Nullable[TrialInterval]]
    r"""The interval unit for the trial period."""
    trial_interval_count: NotRequired[Nullable[int]]
    r"""The number of interval units for the trial period."""
    name: NotRequired[Nullable[str]]
    description: NotRequired[Nullable[str]]
    r"""The description of the product."""
    recurring_interval: NotRequired[Nullable[SubscriptionRecurringInterval]]
    r"""The recurring interval of the product. If `None`, the product is a one-time purchase. **Can only be set on legacy recurring products. Once set, it can't be changed.**"""
    is_archived: NotRequired[Nullable[bool]]
    r"""Whether the product is archived. If `true`, the product won't be available for purchase anymore. Existing customers will still have access to their benefits, and subscriptions will continue normally."""
    prices: NotRequired[Nullable[List[ProductUpdatePricesTypedDict]]]
    r"""List of available prices for this product. If you want to keep existing prices, include them in the list as an `ExistingProductPrice` object."""
    medias: NotRequired[Nullable[List[str]]]
    r"""List of file IDs. Each one must be on the same organization as the product, of type `product_media` and correctly uploaded."""
    attached_custom_fields: NotRequired[
        Nullable[List[AttachedCustomFieldCreateTypedDict]]
    ]


class ProductUpdate(BaseModel):
    r"""Schema to update a product."""

    metadata: Optional[Dict[str, ProductUpdateMetadata]] = None
    r"""Key-value object allowing you to store additional information.

    The key must be a string with a maximum length of **40 characters**.
    The value must be either:

    * A string with a maximum length of **500 characters**
    * An integer
    * A floating-point number
    * A boolean

    You can store up to **50 key-value pairs**.
    """

    trial_interval: OptionalNullable[TrialInterval] = UNSET
    r"""The interval unit for the trial period."""

    trial_interval_count: OptionalNullable[int] = UNSET
    r"""The number of interval units for the trial period."""

    name: OptionalNullable[str] = UNSET

    description: OptionalNullable[str] = UNSET
    r"""The description of the product."""

    recurring_interval: OptionalNullable[SubscriptionRecurringInterval] = UNSET
    r"""The recurring interval of the product. If `None`, the product is a one-time purchase. **Can only be set on legacy recurring products. Once set, it can't be changed.**"""

    is_archived: OptionalNullable[bool] = UNSET
    r"""Whether the product is archived. If `true`, the product won't be available for purchase anymore. Existing customers will still have access to their benefits, and subscriptions will continue normally."""

    prices: OptionalNullable[List[ProductUpdatePrices]] = UNSET
    r"""List of available prices for this product. If you want to keep existing prices, include them in the list as an `ExistingProductPrice` object."""

    medias: OptionalNullable[List[str]] = UNSET
    r"""List of file IDs. Each one must be on the same organization as the product, of type `product_media` and correctly uploaded."""

    attached_custom_fields: OptionalNullable[List[AttachedCustomFieldCreate]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "metadata",
            "trial_interval",
            "trial_interval_count",
            "name",
            "description",
            "recurring_interval",
            "is_archived",
            "prices",
            "medias",
            "attached_custom_fields",
        ]
        nullable_fields = [
            "trial_interval",
            "trial_interval_count",
            "name",
            "description",
            "recurring_interval",
            "is_archived",
            "prices",
            "medias",
            "attached_custom_fields",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
