"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from polar_sdk.models import PolarError
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated


class ResourceNotFoundData(BaseModel):
    detail: str

    ERROR: Annotated[
        Annotated[
            Literal["ResourceNotFound"],
            AfterValidator(validate_const("ResourceNotFound")),
        ],
        pydantic.Field(alias="error"),
    ] = "ResourceNotFound"


@dataclass(unsafe_hash=True)
class ResourceNotFound(PolarError):
    data: ResourceNotFoundData = field(hash=False)

    def __init__(
        self,
        data: ResourceNotFoundData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
