"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class SeatAssignTypedDict(TypedDict):
    subscription_id: NotRequired[Nullable[str]]
    r"""Subscription ID. Required if checkout_id is not provided."""
    checkout_id: NotRequired[Nullable[str]]
    r"""Checkout ID. Used to look up subscription. Required if subscription_id is not provided."""
    email: NotRequired[Nullable[str]]
    r"""Email of the customer to assign the seat to"""
    external_customer_id: NotRequired[Nullable[str]]
    r"""External customer ID for the seat assignment"""
    customer_id: NotRequired[Nullable[str]]
    r"""Customer ID for the seat assignment"""
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Additional metadata for the seat (max 10 keys, 1KB total)"""


class SeatAssign(BaseModel):
    subscription_id: OptionalNullable[str] = UNSET
    r"""Subscription ID. Required if checkout_id is not provided."""

    checkout_id: OptionalNullable[str] = UNSET
    r"""Checkout ID. Used to look up subscription. Required if subscription_id is not provided."""

    email: OptionalNullable[str] = UNSET
    r"""Email of the customer to assign the seat to"""

    external_customer_id: OptionalNullable[str] = UNSET
    r"""External customer ID for the seat assignment"""

    customer_id: OptionalNullable[str] = UNSET
    r"""Customer ID for the seat assignment"""

    metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Additional metadata for the seat (max 10 keys, 1KB total)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "subscription_id",
            "checkout_id",
            "email",
            "external_customer_id",
            "customer_id",
            "metadata",
        ]
        nullable_fields = [
            "subscription_id",
            "checkout_id",
            "email",
            "external_customer_id",
            "customer_id",
            "metadata",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
