"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customer import Customer, CustomerTypedDict
from .subscriptioncycledmetadata import (
    SubscriptionCycledMetadata,
    SubscriptionCycledMetadataTypedDict,
)
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from polar_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class SubscriptionCycledEventTypedDict(TypedDict):
    r"""An event created by Polar when a subscription is cycled."""

    id: str
    r"""The ID of the object."""
    timestamp: datetime
    r"""The timestamp of the event."""
    organization_id: str
    r"""The ID of the organization owning the event."""
    customer_id: Nullable[str]
    r"""ID of the customer in your Polar organization associated with the event."""
    customer: Nullable[CustomerTypedDict]
    r"""The customer associated with the event."""
    external_customer_id: Nullable[str]
    r"""ID of the customer in your system associated with the event."""
    metadata: SubscriptionCycledMetadataTypedDict
    source: Literal["system"]
    r"""The source of the event. `system` events are created by Polar. `user` events are the one you create through our ingestion API."""
    name: Literal["subscription.cycled"]
    r"""The name of the event."""


class SubscriptionCycledEvent(BaseModel):
    r"""An event created by Polar when a subscription is cycled."""

    id: str
    r"""The ID of the object."""

    timestamp: datetime
    r"""The timestamp of the event."""

    organization_id: str
    r"""The ID of the organization owning the event."""

    customer_id: Nullable[str]
    r"""ID of the customer in your Polar organization associated with the event."""

    customer: Nullable[Customer]
    r"""The customer associated with the event."""

    external_customer_id: Nullable[str]
    r"""ID of the customer in your system associated with the event."""

    metadata: SubscriptionCycledMetadata

    SOURCE: Annotated[
        Annotated[Literal["system"], AfterValidator(validate_const("system"))],
        pydantic.Field(alias="source"),
    ] = "system"
    r"""The source of the event. `system` events are created by Polar. `user` events are the one you create through our ingestion API."""

    NAME: Annotated[
        Annotated[
            Literal["subscription.cycled"],
            AfterValidator(validate_const("subscription.cycled")),
        ],
        pydantic.Field(alias="name"),
    ] = "subscription.cycled"
    r"""The name of the event."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["customer_id", "customer", "external_customer_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
