"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import List, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


OrganizationIDTypedDict = TypeAliasType(
    "OrganizationIDTypedDict", Union[str, List[str]]
)
r"""Filter by organization ID."""


OrganizationID = TypeAliasType("OrganizationID", Union[str, List[str]])
r"""Filter by organization ID."""


class SubscriptionsExportRequestTypedDict(TypedDict):
    organization_id: NotRequired[Nullable[OrganizationIDTypedDict]]
    r"""Filter by organization ID."""


class SubscriptionsExportRequest(BaseModel):
    organization_id: Annotated[
        OptionalNullable[OrganizationID],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by organization ID."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["organization_id"]
        nullable_fields = ["organization_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
