"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .licensekeyactivationbase import (
    LicenseKeyActivationBase,
    LicenseKeyActivationBaseTypedDict,
)
from .licensekeycustomer import LicenseKeyCustomer, LicenseKeyCustomerTypedDict
from .licensekeystatus import LicenseKeyStatus
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class ValidatedLicenseKeyTypedDict(TypedDict):
    id: str
    r"""The ID of the object."""
    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    organization_id: str
    customer_id: str
    customer: LicenseKeyCustomerTypedDict
    benefit_id: str
    r"""The benefit ID."""
    key: str
    display_key: str
    status: LicenseKeyStatus
    limit_activations: Nullable[int]
    usage: int
    limit_usage: Nullable[int]
    validations: int
    last_validated_at: Nullable[datetime]
    expires_at: Nullable[datetime]
    activation: NotRequired[Nullable[LicenseKeyActivationBaseTypedDict]]


class ValidatedLicenseKey(BaseModel):
    id: str
    r"""The ID of the object."""

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    organization_id: str

    customer_id: str

    customer: LicenseKeyCustomer

    benefit_id: str
    r"""The benefit ID."""

    key: str

    display_key: str

    status: LicenseKeyStatus

    limit_activations: Nullable[int]

    usage: int

    limit_usage: Nullable[int]

    validations: int

    last_validated_at: Nullable[datetime]

    expires_at: Nullable[datetime]

    activation: OptionalNullable[LicenseKeyActivationBase] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["activation"]
        nullable_fields = [
            "modified_at",
            "limit_activations",
            "limit_usage",
            "last_validated_at",
            "expires_at",
            "activation",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
