"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customerstate import CustomerState, CustomerStateTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class WebhookCustomerStateChangedPayloadTypedDict(TypedDict):
    r"""Sent when a customer state has changed.

    It's triggered when:

    * Customer is created, updated or deleted.
    * A subscription is created or updated.
    * A benefit is granted or revoked.

    **Discord & Slack support:** Basic
    """

    timestamp: datetime
    data: CustomerStateTypedDict
    r"""A customer along with additional state information:

    * Active subscriptions
    * Granted benefits
    * Active meters
    """
    type: Literal["customer.state_changed"]


class WebhookCustomerStateChangedPayload(BaseModel):
    r"""Sent when a customer state has changed.

    It's triggered when:

    * Customer is created, updated or deleted.
    * A subscription is created or updated.
    * A benefit is granted or revoked.

    **Discord & Slack support:** Basic
    """

    timestamp: datetime

    data: CustomerState
    r"""A customer along with additional state information:

    * Active subscriptions
    * Granted benefits
    * Active meters
    """

    TYPE: Annotated[
        Annotated[
            Literal["customer.state_changed"],
            AfterValidator(validate_const("customer.state_changed")),
        ],
        pydantic.Field(alias="type"),
    ] = "customer.state_changed"
