"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhookeventtype import WebhookEventType
from .webhookformat import WebhookFormat
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict


class WebhookEndpointUpdateTypedDict(TypedDict):
    r"""Schema to update a webhook endpoint."""

    url: NotRequired[Nullable[str]]
    secret: NotRequired[Nullable[str]]
    format_: NotRequired[Nullable[WebhookFormat]]
    events: NotRequired[Nullable[List[WebhookEventType]]]


class WebhookEndpointUpdate(BaseModel):
    r"""Schema to update a webhook endpoint."""

    url: OptionalNullable[str] = UNSET

    secret: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = UNSET

    format_: Annotated[
        OptionalNullable[WebhookFormat], pydantic.Field(alias="format")
    ] = UNSET

    events: OptionalNullable[List[WebhookEventType]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["url", "secret", "format", "events"]
        nullable_fields = ["url", "secret", "format", "events"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
