"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhookeventtype import WebhookEventType
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class WebhookEventTypedDict(TypedDict):
    r"""A webhook event.

    An event represent something that happened in the system
    that should be sent to the webhook endpoint.

    It can be delivered multiple times until it's marked as succeeded,
    each one creating a new delivery.
    """

    created_at: datetime
    r"""Creation timestamp of the object."""
    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""
    id: str
    r"""The ID of the object."""
    payload: Nullable[str]
    r"""The payload of the webhook event."""
    type: WebhookEventType
    is_archived: bool
    r"""Whether this event is archived. Archived events can't be redelivered, and the payload is not accessible anymore."""
    last_http_code: NotRequired[Nullable[int]]
    r"""Last HTTP code returned by the URL. `null` if no delviery has been attempted or if the endpoint was unreachable."""
    succeeded: NotRequired[Nullable[bool]]
    r"""Whether this event was successfully delivered. `null` if no delivery has been attempted."""


class WebhookEvent(BaseModel):
    r"""A webhook event.

    An event represent something that happened in the system
    that should be sent to the webhook endpoint.

    It can be delivered multiple times until it's marked as succeeded,
    each one creating a new delivery.
    """

    created_at: datetime
    r"""Creation timestamp of the object."""

    modified_at: Nullable[datetime]
    r"""Last modification timestamp of the object."""

    id: str
    r"""The ID of the object."""

    payload: Nullable[str]
    r"""The payload of the webhook event."""

    type: WebhookEventType

    is_archived: bool
    r"""Whether this event is archived. Archived events can't be redelivered, and the payload is not accessible anymore."""

    last_http_code: OptionalNullable[int] = UNSET
    r"""Last HTTP code returned by the URL. `null` if no delviery has been attempted or if the endpoint was unreachable."""

    succeeded: OptionalNullable[bool] = UNSET
    r"""Whether this event was successfully delivered. `null` if no delivery has been attempted."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["last_http_code", "succeeded"]
        nullable_fields = ["modified_at", "last_http_code", "succeeded", "payload"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
