"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .order import Order, OrderTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class WebhookOrderUpdatedPayloadTypedDict(TypedDict):
    r"""Sent when an order is updated.

    An order is updated when:

    * Its status changes, e.g. from `pending` to `paid`.
    * It's refunded, partially or fully.

    **Discord & Slack support:** Full
    """

    timestamp: datetime
    data: OrderTypedDict
    type: Literal["order.updated"]


class WebhookOrderUpdatedPayload(BaseModel):
    r"""Sent when an order is updated.

    An order is updated when:

    * Its status changes, e.g. from `pending` to `paid`.
    * It's refunded, partially or fully.

    **Discord & Slack support:** Full
    """

    timestamp: datetime

    data: Order

    TYPE: Annotated[
        Annotated[
            Literal["order.updated"], AfterValidator(validate_const("order.updated"))
        ],
        pydantic.Field(alias="type"),
    ] = "order.updated"
