"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .listresource_webhookdelivery_ import (
    ListResourceWebhookDelivery,
    ListResourceWebhookDeliveryTypedDict,
)
from datetime import datetime
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


EndpointIDTypedDict = TypeAliasType("EndpointIDTypedDict", Union[str, List[str]])
r"""Filter by webhook endpoint ID."""


EndpointID = TypeAliasType("EndpointID", Union[str, List[str]])
r"""Filter by webhook endpoint ID."""


class WebhooksListWebhookDeliveriesRequestTypedDict(TypedDict):
    endpoint_id: NotRequired[Nullable[EndpointIDTypedDict]]
    r"""Filter by webhook endpoint ID."""
    start_timestamp: NotRequired[Nullable[datetime]]
    r"""Filter deliveries after this timestamp."""
    end_timestamp: NotRequired[Nullable[datetime]]
    r"""Filter deliveries before this timestamp."""
    page: NotRequired[int]
    r"""Page number, defaults to 1."""
    limit: NotRequired[int]
    r"""Size of a page, defaults to 10. Maximum is 100."""


class WebhooksListWebhookDeliveriesRequest(BaseModel):
    endpoint_id: Annotated[
        OptionalNullable[EndpointID],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter by webhook endpoint ID."""

    start_timestamp: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter deliveries after this timestamp."""

    end_timestamp: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter deliveries before this timestamp."""

    page: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""Page number, defaults to 1."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 10
    r"""Size of a page, defaults to 10. Maximum is 100."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "endpoint_id",
            "start_timestamp",
            "end_timestamp",
            "page",
            "limit",
        ]
        nullable_fields = ["endpoint_id", "start_timestamp", "end_timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class WebhooksListWebhookDeliveriesResponseTypedDict(TypedDict):
    result: ListResourceWebhookDeliveryTypedDict


class WebhooksListWebhookDeliveriesResponse(BaseModel):
    next: Callable[[], Optional[WebhooksListWebhookDeliveriesResponse]]

    result: ListResourceWebhookDelivery
