"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .subscription import Subscription, SubscriptionTypedDict
from datetime import datetime
from polar_sdk.types import BaseModel
from polar_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class WebhookSubscriptionUpdatedPayloadTypedDict(TypedDict):
    r"""Sent when a subscription is updated. This event fires for all changes to the subscription, including renewals.

    If you want more specific events, you can listen to `subscription.active`, `subscription.canceled`, and `subscription.revoked`.

    To listen specifically for renewals, you can listen to `order.created` events and check the `billing_reason` field.

    **Discord & Slack support:** On cancellation and revocation. Renewals are skipped.
    """

    timestamp: datetime
    data: SubscriptionTypedDict
    type: Literal["subscription.updated"]


class WebhookSubscriptionUpdatedPayload(BaseModel):
    r"""Sent when a subscription is updated. This event fires for all changes to the subscription, including renewals.

    If you want more specific events, you can listen to `subscription.active`, `subscription.canceled`, and `subscription.revoked`.

    To listen specifically for renewals, you can listen to `order.created` events and check the `billing_reason` field.

    **Discord & Slack support:** On cancellation and revocation. Renewals are skipped.
    """

    timestamp: datetime

    data: Subscription

    TYPE: Annotated[
        Annotated[
            Literal["subscription.updated"],
            AfterValidator(validate_const("subscription.updated")),
        ],
        pydantic.Field(alias="type"),
    ] = "subscription.updated"
