"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from polar_sdk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from polar_sdk.utils import FieldMetadata, validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class WebTokenRequestSubType(str, Enum):
    USER = "user"
    ORGANIZATION = "organization"


class WebTokenRequestTypedDict(TypedDict):
    client_id: str
    client_secret: str
    session_token: str
    grant_type: Literal["web"]
    sub_type: NotRequired[WebTokenRequestSubType]
    sub: NotRequired[Nullable[str]]
    scope: NotRequired[Nullable[str]]


class WebTokenRequest(BaseModel):
    client_id: Annotated[str, FieldMetadata(form=True)]

    client_secret: Annotated[str, FieldMetadata(form=True)]

    session_token: Annotated[str, FieldMetadata(form=True)]

    GRANT_TYPE: Annotated[
        Annotated[Literal["web"], AfterValidator(validate_const("web"))],
        pydantic.Field(alias="grant_type"),
        FieldMetadata(form=True),
    ] = "web"

    sub_type: Annotated[Optional[WebTokenRequestSubType], FieldMetadata(form=True)] = (
        WebTokenRequestSubType.USER
    )

    sub: Annotated[OptionalNullable[str], FieldMetadata(form=True)] = UNSET

    scope: Annotated[OptionalNullable[str], FieldMetadata(form=True)] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sub_type", "sub", "scope"]
        nullable_fields = ["sub", "scope"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
